@php
    use App\Enums\PermissionMenuEnum;
    use App\Enums\PermissionActionEnum;
@endphp
@if (
    $_auth_user->can(PermissionMenuEnum::B2X_LOAN_AVAILABLE_PACKAGES->value . '.' . PermissionActionEnum::READ->value) ||
        $_auth_user->can(PermissionMenuEnum::B2X_LOAN_PENDING_LOANS->value . '.' . PermissionActionEnum::READ->value) ||
        $_auth_user->can(PermissionMenuEnum::B2X_LOAN_LOAN_SUMMARY->value . '.' . PermissionActionEnum::READ->value) ||
        $_auth_user->can(PermissionMenuEnum::B2X_LOAN_WITHDRAWAL_PENDING->value . '.' . PermissionActionEnum::READ->value) ||
        $_auth_user->can(PermissionMenuEnum::B2X_LOAN_CLOSED_LOANS->value . '.' . PermissionActionEnum::READ->value) ||
        $_auth_user->can(PermissionMenuEnum::B2X_LOAN_THE_MONTHS_REPAYMENTS->value . '.' . PermissionActionEnum::READ->value) ||
        $_auth_user->can(PermissionMenuEnum::B2X_LOAN_ALL_LOAN_REPAYMENTS->value . '.' . PermissionActionEnum::READ->value))
    <!-- B2X -->
    <li>
        <a class="has-arrow material-ripple" href="#">
            <svg class="menu-icon" width="24" height="23" viewBox="0 0 24 23" fill="none"
                xmlns="http://www.w3.org/2000/svg">
                <path
                    d="M23.7655 13.9966C23.2365 13.2062 21.9653 12.7837 20.7929 13.1629C21.0739 12.5353 21.2268 11.8544 21.2268 11.1567C21.2268 8.39866 18.936 6.15497 16.1202 6.15497C13.3044 6.15497 11.0137 8.39866 11.0137 11.1567C11.0137 11.6531 11.0908 12.1464 11.2378 12.6185C9.38742 11.9506 8.6872 12.2302 4.69533 14.2988L4.49487 14.0156C4.18826 13.5824 3.57813 13.4734 3.13496 13.774L0.420506 15.6165C0.206244 15.7618 0.0626518 15.9805 0.0159139 16.2325C-0.0305424 16.4843 0.0254868 16.7386 0.173866 16.9484L4.16376 22.588C4.31214 22.7979 4.53541 22.9385 4.79275 22.9843C4.85188 22.9948 4.911 23 4.96985 23C5.16694 23 5.35896 22.9415 5.52395 22.8296L8.23812 20.9871C8.68101 20.6865 8.79166 20.0892 8.48476 19.6554L8.38903 19.5203L8.57993 19.2398C8.63173 19.1635 8.71958 19.1328 8.80911 19.1601L14.059 20.753C14.2301 20.8048 14.4163 20.8294 14.6147 20.8294C16.4736 20.8294 19.424 18.6919 21.6358 17.0894C22.2586 16.6382 22.7964 16.2485 23.1937 15.9934C24.1788 15.3603 24.1175 14.5222 23.7655 13.9966ZM16.1199 6.91335C18.5086 6.91335 20.4522 8.81673 20.4522 11.1567C20.4522 12.1905 20.0682 13.1855 19.3713 13.9602L16.9446 15.5191C16.9074 15.3691 16.852 15.2221 16.7748 15.0826C16.5411 14.6595 16.1546 14.3515 15.6866 14.215C14.1085 13.7547 13.0248 13.3281 12.2201 13.003C11.9377 12.4307 11.7877 11.7967 11.7877 11.1567C11.7877 8.81701 13.7312 6.91335 16.1199 6.91335ZM7.79693 20.3636L5.08275 22.2061C5.02306 22.2466 4.96196 22.2436 4.93099 22.2378C4.89974 22.2323 4.84146 22.2143 4.80035 22.1556L0.810176 16.5163C0.768788 16.4578 0.772167 16.398 0.777798 16.3677C0.783429 16.3373 0.80173 16.2802 0.861419 16.2397L3.5756 14.3973C3.61079 14.3736 3.65105 14.362 3.69075 14.362C3.75523 14.362 3.81858 14.3918 3.85799 14.4475L7.84817 20.087C7.91208 20.1772 7.889 20.3013 7.79693 20.3636ZM22.7691 15.3589C22.3535 15.6258 21.8076 16.0213 21.1755 16.4794C19.1238 17.9658 15.6903 20.4541 14.2881 20.0283L9.0383 18.4354C8.62132 18.3091 8.17815 18.4627 7.93602 18.8187L7.9149 18.8499L5.13934 14.9268C9.4367 12.6999 9.51215 12.7275 11.7544 13.635C12.5907 13.9734 13.736 14.437 15.4659 14.9416C15.7356 15.0202 15.9589 15.1987 16.094 15.4436C16.2292 15.6884 16.2596 15.9689 16.1791 16.2331C16.0143 16.7744 15.4211 17.0872 14.8558 16.9305L10.4376 15.7044C10.2315 15.6468 10.0178 15.7643 9.95954 15.9659C9.90126 16.1672 10.0209 16.377 10.2265 16.4341L14.6446 17.6602C14.813 17.7071 14.983 17.7292 15.1503 17.7292C15.9473 17.7292 16.6859 17.2239 16.9212 16.4498C16.9224 16.4465 16.9226 16.4432 16.9238 16.4396L20.5519 14.1091C21.5604 13.4613 22.7452 13.8562 23.1179 14.4127C23.3423 14.7478 23.2249 15.066 22.7691 15.3589ZM5.92319 20.3245C6.04538 20.4963 6.00231 20.7326 5.82718 20.8523C5.75961 20.8983 5.68246 20.9204 5.60616 20.9204C5.48397 20.9204 5.36346 20.8639 5.28829 20.758L5.26745 20.7287C5.14526 20.5569 5.18833 20.3206 5.36346 20.2009C5.53859 20.0812 5.78044 20.1231 5.90235 20.2949L5.92319 20.3245ZM9.54228 3.84979V2.33304C9.54228 2.12345 9.71543 1.95385 9.92941 1.95385C10.1434 1.95385 10.3166 2.12345 10.3166 2.33304V3.84979C10.3166 4.05938 10.1434 4.22898 9.92941 4.22898C9.71543 4.22898 9.54228 4.0591 9.54228 3.84979ZM9.54228 7.64139V6.12491C9.54228 5.91533 9.71543 5.74573 9.92941 5.74573C10.1434 5.74573 10.3166 5.91533 10.3166 6.12491V7.64139C10.3166 7.85098 10.1434 8.02058 9.92941 8.02058C9.71543 8.02058 9.54228 7.85098 9.54228 7.64139ZM9.54228 10.3467V9.91651C9.54228 9.70693 9.71543 9.53733 9.92941 9.53733C10.1434 9.53733 10.3166 9.70693 10.3166 9.91651V10.3467C10.3166 10.5563 10.1434 10.7259 9.92941 10.7259C9.71543 10.7259 9.54228 10.556 9.54228 10.3467ZM11.9797 6.34002V5.6219C11.9797 5.41232 12.1528 5.24272 12.3668 5.24272C12.5808 5.24272 12.754 5.41232 12.754 5.6219V6.34002C12.754 6.5496 12.5808 6.7192 12.3668 6.7192C12.1531 6.7192 11.9797 6.54933 11.9797 6.34002ZM11.9797 3.34678V1.83003C11.9797 1.62044 12.1528 1.45084 12.3668 1.45084C12.5808 1.45084 12.754 1.62044 12.754 1.83003V3.34678C12.754 3.55637 12.5808 3.72597 12.3668 3.72597C12.1531 3.72597 11.9797 3.55637 11.9797 3.34678ZM14.4174 4.65918V4.41429C14.4174 4.20471 14.5905 4.03511 14.8045 4.03511C15.0185 4.03511 15.1916 4.20471 15.1916 4.41429V4.65918C15.1916 4.86877 15.0185 5.03837 14.8045 5.03837C14.5905 5.03837 14.4174 4.86877 14.4174 4.65918ZM14.4174 2.13945V0.622695C14.4174 0.413108 14.5905 0.243507 14.8045 0.243507C15.0185 0.243507 15.1916 0.413108 15.1916 0.622695V2.13945C15.1916 2.34903 15.0185 2.51863 14.8045 2.51863C14.5905 2.51863 14.4174 2.34876 14.4174 2.13945ZM16.8548 4.63023V4.17106C16.8548 3.96148 17.0279 3.79188 17.2419 3.79188C17.4559 3.79188 17.6291 3.96148 17.6291 4.17106V4.63023C17.6291 4.83981 17.4559 5.00941 17.2419 5.00941C17.0279 5.00941 16.8548 4.83954 16.8548 4.63023ZM16.8548 1.89594V0.379188C16.8548 0.1696 17.0279 0 17.2419 0C17.4559 0 17.6291 0.1696 17.6291 0.379188V1.89594C17.6291 2.10553 17.4559 2.27513 17.2419 2.27513C17.0279 2.27513 16.8548 2.10553 16.8548 1.89594ZM19.2922 3.06687V1.55012C19.2922 1.34053 19.4654 1.17093 19.6793 1.17093C19.8933 1.17093 20.0665 1.34053 20.0665 1.55012V3.06687C20.0665 3.27646 19.8933 3.44606 19.6793 3.44606C19.4656 3.44606 19.2922 3.27646 19.2922 3.06687ZM19.2922 5.83011V5.34199C19.2922 5.13241 19.4654 4.96281 19.6793 4.96281C19.8933 4.96281 20.0665 5.13241 20.0665 5.34199V5.83011C20.0665 6.0397 19.8933 6.2093 19.6793 6.2093C19.4656 6.2093 19.2922 6.03942 19.2922 5.83011ZM21.7299 7.64139V6.12491C21.7299 5.91533 21.903 5.74573 22.117 5.74573C22.331 5.74573 22.5042 5.91533 22.5042 6.12491V7.64139C22.5042 7.85098 22.331 8.02058 22.117 8.02058C21.903 8.02058 21.7299 7.85098 21.7299 7.64139ZM21.7299 3.84979V2.33304C21.7299 2.12345 21.903 1.95385 22.117 1.95385C22.331 1.95385 22.5042 2.12345 22.5042 2.33304V3.84979C22.5042 4.05938 22.331 4.22898 22.117 4.22898C21.903 4.22898 21.7299 4.0591 21.7299 3.84979ZM21.7299 10.3467V9.91651C21.7299 9.70693 21.903 9.53733 22.117 9.53733C22.331 9.53733 22.5042 9.70693 22.5042 9.91651V10.3467C22.5042 10.5563 22.331 10.7259 22.117 10.7259C21.903 10.7259 21.7299 10.556 21.7299 10.3467ZM14.7001 10.6299C14.5964 10.3258 14.6305 10.002 14.7955 9.71851C14.983 9.39668 15.3231 9.15952 15.7328 9.05941V8.60494C15.7328 8.39535 15.906 8.22575 16.1199 8.22575C16.3339 8.22575 16.5071 8.39535 16.5071 8.60494V9.04231C16.9643 9.13056 17.361 9.38979 17.5573 9.77284C17.6533 9.95981 17.5761 10.1879 17.3852 10.2819C17.1941 10.3762 16.9615 10.3004 16.8655 10.1134C16.7306 9.85033 16.3286 9.7072 15.9502 9.7869C15.7305 9.83323 15.5549 9.94547 15.4681 10.0947C15.4118 10.1912 15.4006 10.2907 15.4346 10.3908C15.5275 10.6644 15.7142 10.7198 16.1847 10.7984C16.6518 10.8765 17.2915 10.9832 17.5401 11.7154C17.6434 12.0196 17.6096 12.3433 17.4444 12.6268C17.2568 12.9486 16.9167 13.1858 16.5071 13.2859V13.75C16.5071 13.9596 16.3339 14.1292 16.1199 14.1292C15.906 14.1292 15.7328 13.9596 15.7328 13.75V13.3041C15.2753 13.2159 14.8791 12.9555 14.6826 12.5728C14.5866 12.3858 14.6637 12.1577 14.8546 12.0637C15.0455 11.9696 15.2784 12.0452 15.3744 12.2322C15.5095 12.495 15.9113 12.6389 16.29 12.5587C16.5093 12.5124 16.685 12.4001 16.772 12.2509C16.8283 12.1544 16.8396 12.0549 16.8055 11.9548C16.7123 11.6804 16.5257 11.6247 16.0546 11.5461C15.5875 11.4677 14.9484 11.361 14.7001 10.6299Z"
                    fill="#6C6C6C" />
            </svg>
            <span class="lh-1 ps-2">{{ localize('B2X Loan') }}</span>
        </a>
        <ul class="nav-second-level mm-collapse">
            @if ($_auth_user->can(PermissionMenuEnum::B2X_LOAN_AVAILABLE_PACKAGES->value . '.' . PermissionActionEnum::READ->value))
                <li>
                    <a href="{{ route('b2xloan.package.index') }}">{{ localize('Available Packages') }}</a>
                </li>
            @endif
            @if ($_auth_user->can(PermissionMenuEnum::B2X_LOAN_PENDING_LOANS->value . '.' . PermissionActionEnum::READ->value))
                <li>
                    <a href="{{ route('b2x-loans') }}">{{ localize('Pending Loans') }}</a>
                </li>
            @endif
            @if ($_auth_user->can(PermissionMenuEnum::B2X_LOAN_LOAN_SUMMARY->value . '.' . PermissionActionEnum::READ->value))
                <li>
                    <a href="{{ route('b2x-loans-summary') }}">{{ localize('Loan Summary') }}</a>
                </li>
            @endif
            @if ($_auth_user->can(PermissionMenuEnum::B2X_LOAN_WITHDRAWAL_PENDING->value . '.' . PermissionActionEnum::READ->value))
                <li>
                    <a href="{{ route('b2x-loans.pending-withdraw') }}">{{ localize('Withdrawal Pending') }}</a>
                </li>
            @endif
            @if ($_auth_user->can(PermissionMenuEnum::B2X_LOAN_CLOSED_LOANS->value . '.' . PermissionActionEnum::READ->value))
                <li>
                    <a href="{{ route('b2x-closed-loans') }}">{{ localize('Closed Loans') }}</a>
                </li>
            @endif
            @if ($_auth_user->can(PermissionMenuEnum::B2X_LOAN_THE_MONTHS_REPAYMENTS->value . '.' . PermissionActionEnum::READ->value))
                <li>
                    <a href="{{ route('month.repayment') }}">{{ localize('This Month\'s Repayments') }}</a>
                </li>
            @endif
            @if ($_auth_user->can(PermissionMenuEnum::B2X_LOAN_ALL_LOAN_REPAYMENTS->value . '.' . PermissionActionEnum::READ->value))
                <li>
                    <a href="{{ route('repayments') }}">{{ localize('All Loan Repayments') }}</a>
                </li>
            @endif
        </ul>
    </li>
    <!-- B2X -->
@endif
