@php
    use App\Enums\StatusEnum;
@endphp

<div class="modal fade" id="updateMerchantTitle" tabindex="-1" aria-labelledby="updateMerchantTitleLabel"
    aria-hidden="true">
    <div class="modal-dialog modal-dialog-scrollable modal-lg">
        <div class="modal-content radius-35">
            <div class="modal-header p-4">
                <h5 class="modal-title text-color-5 fs-20 fw-medium" id="modelTitleLabel">
                    {{ localize('Update Merchant Title') }}</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body p-4 pt-2">
                <form action="#" method="post" class="needs-validation" data="showTitleCallBackData"
                    id="merchant-title-form" novalidate="" data-insert="#" enctype="multipart/form-data"
                    data-getData="{{ route('admin.cms.merchant.title.getArticleLang', [':language', ':article']) }}">
                    @csrf
                    <input type="hidden" name="title_article_id" id="title_article_id" value="0" />
                    <div class="row mb-3">

                        <div class="col-12 col-md-6">
                            <div class="mb-3">
                                <label class="col-form-label text-start text-color-1 fs-16 fw-medium"
                                    for="merchant_title">{{ localize('Title') }} <span class="text-danger">*</span>
                                </label>
                                <input type="text" name="merchant_title" id="merchant_title"
                                    value="{{ old('name') }}"
                                    class="custom-form-control form-control @error('merchant_title') is-invalid @enderror"
                                    placeholder="{{ localize('enter title') }}" required />
                                <div class="invalid-feedback" role="alert">
                                    @error('merchant_title')
                                        {{ $message }}
                                    @enderror
                                </div>
                            </div>
                        </div>

                        <div class="col-12 col-md-6">
                            <div class="mb-3">
                                <label class="col-form-label text-start text-color-1 fs-16 fw-medium"
                                    for="title_language_id">{{ localize('Language') }} <span
                                        class="text-danger">*</span>
                                </label>
                                <select name="title_language_id" id="title_language_id" data-allowClear="true"
                                    data-placeholder="{{ localize('Language') }}"
                                    class="custom-form-control placeholder-single @error('title_language_id') is-invalid @enderror"
                                    required>
                                    @foreach ($languages as $language)
                                        <option value="{{ $language->id }}" @selected($language->id === ($setting->language_id ?? null))>
                                            {{ $language->name }}</option>
                                    @endforeach
                                </select>
                                <div class="invalid-feedback" role="alert">
                                    @error('title_language_id')
                                        {{ $message }}
                                    @enderror
                                </div>
                            </div>
                        </div>

                        <div class="col-12 col-md-6">
                            <div class="mb-3">
                                <label class="col-form-label text-start text-color-1 fs-16 fw-medium"
                                    for="merchant_title_header">{{ localize('Title Header') }} <span
                                        class="text-danger">*</span>
                                </label>
                                <input type="text" name="merchant_title_header" id="merchant_title_header"
                                    value="{{ old('name') }}"
                                    class="custom-form-control form-control @error('merchant_title_header') is-invalid @enderror"
                                    placeholder="{{ localize('enter title header') }}" required />
                                <div class="invalid-feedback" role="alert">
                                    @error('merchant_title_header')
                                        {{ $message }}
                                    @enderror
                                </div>
                            </div>
                        </div>

                        <div class="col-12 col-md-6">
                            <div class="mb-3">
                                <label class="col-form-label text-start text-color-1 fs-16 fw-medium"
                                    for="merchant_title_content">{{ localize('Title Content') }} <span
                                        class="text-danger">*</span>
                                </label>
                                <input type="text" name="merchant_title_content" id="merchant_title_content"
                                    value="{{ old('name') }}"
                                    class="custom-form-control form-control @error('merchant_title_content') is-invalid @enderror"
                                    placeholder="{{ localize('enter title content') }}" required />
                                <div class="invalid-feedback" role="alert">
                                    @error('merchant_title_content')
                                        {{ $message }}
                                    @enderror
                                </div>
                            </div>
                        </div>
                        <div class="col-12 col-md-6">
                            <div class="mb-3">
                                <label class="col-form-label text-start text-color-1 fs-16 fw-medium"
                                    for="title_status">{{ localize('Status') }} <span class="text-danger">*</span>
                                </label>
                                <select name="title_status" id="title_status" data-allowClear="true"
                                    data-placeholder="{{ localize('Status') }}"
                                    class="custom-form-control placeholder-single @error('title_status') is-invalid @enderror"
                                    required>
                                    <option value="{{ StatusEnum::ACTIVE->value }}">
                                        {{ enum_ucfirst_case(StatusEnum::ACTIVE->name) }}</option>
                                    <option value="{{ StatusEnum::INACTIVE->value }}">
                                        {{ enum_ucfirst_case(StatusEnum::INACTIVE->name) }}</option>
                                </select>
                                <div class="invalid-feedback" role="alert">
                                    @error('title_status')
                                        {{ $message }}
                                    @enderror
                                </div>
                            </div>
                        </div>

                    </div>
                    <div class="d-flex flex-row gap-3">
                        <button type="reset" class="btn btn-reset py-2 resetBtn w-25"
                            title="{{ localize('Reset') }}">
                            <i class="fa fa-undo-alt"></i>
                        </button>
                        <button type="submit" class="actionBtn btn btn-save py-2 w-75"
                            id="merchantTitleFormActionBtn">{{ localize('Create') }}</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
