<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class AcceptCurrencyRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            "currency_name"            => ["required", "string", "max:50"],
            "currency_symbol"          => ["required", "string", "max:15"],
            "accept_payment_gateway.*" => ["required", "integer"],
            "status"                   => ["required", "string", "min:1"],
        ];
    }
}
