@php
    use App\Enums\TxnTypeEnum;
    use Carbon\Carbon;
    use App\Enums\PermissionMenuEnum;
    use App\Enums\PermissionActionEnum;
    $currentMonthYear = Carbon::now()->format('F Y');
@endphp

<x-app-layout>
    @if ($_auth_user->can(PermissionMenuEnum::DASHBOARD->value . '.' . PermissionActionEnum::READ->value))
        <div class="row g-3 mb-3">
            <div class="col-md-6 col-lg-4 col-xl-3">
                <div class="card shadow-none radius-12">
                    <div class="card-body">
                        <div class="d-flex align-items-center gap-2 gap-xxl-3">
                            <div class="badge p-2 bg-label-success rounded">
                                <svg width="37" height="27" viewBox="0 0 37 27" fill="none"
                                    xmlns="http://www.w3.org/2000/svg">
                                    <path
                                        d="M27.8333 25.19C27.8333 22.518 23.5427 20.352 18.25 20.352C12.9573 20.352 8.6667 22.518 8.6667 25.19M35.5 20.3526C35.5 18.3687 33.1346 16.6637 29.75 15.9172M1 20.3526C1 18.3687 3.36536 16.6637 6.75 15.9172M29.75 9.4441C30.9263 8.5582 31.6667 7.27085 31.6667 5.838C31.6667 3.16605 29.0924 1 25.9167 1C24.4439 1 23.1007 1.46582 22.0833 2.2319M6.75 9.4441C5.57365 8.5582 4.83333 7.27085 4.83333 5.838C4.83333 3.16605 7.4077 1 10.5833 1C12.056 1 13.3994 1.46582 14.4167 2.2319M18.25 15.514C15.0743 15.514 12.5 13.348 12.5 10.676C12.5 8.0041 15.0743 5.838 18.25 5.838C21.4257 5.838 24 8.0041 24 10.676C24 13.348 21.4257 15.514 18.25 15.514Z"
                                        stroke="#219653" stroke-width="2" stroke-linecap="round"
                                        stroke-linejoin="round" />
                                </svg>

                            </div>
                            <div class="d-flex flex-column">
                                <h5 class="text-black fs-16 fw-semi-bold text-uppercase mb-1">
                                    {{ localize('Customers') }}
                                </h5>
                                <span class="fs-13 text-muted fw-medium">{{ localize('Total customers') }}</span>
                            </div>
                        </div>
                        <div class="d-flex align-items-center gap-2">
                            <h3 class="text-black fs-20 mb-2 mt-1 fw-semi-bold">
                                {{ number_format($customerReport->totalCustomer) }}</h3>
                            <div id="customerChart"></div>
                        </div>
                        <div class="pt-2">
                            <div class="d-flex align-items-center gap-4">
                                <span class="fs-13 text-muted fw-medium">{{ $currentMonthYear }}</span>
                                <span
                                    class="fs-13
                            @if ($customerReport->currentMonthCustomer > 0) text-success
                            @else text-black @endif
                             fw-semi-bold">
                                    @if ($customerReport->currentMonthCustomer > 0)
                                        +
                                    @endif {{ $customerReport->currentMonthCustomer }}
                                </span>
                                <span
                                    class="badge
                            @if ($customerReport->percentageDifference > 0) bg-label-success
                            @else bg-label-danger @endif rounded-pill">
                                    {{ $customerReport->percentageDifference }}%
                                </span>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-md-6 col-lg-4 col-xl-3">
                <div class="card shadow-none radius-12">
                    <div class="card-body">
                        <div class="d-flex align-items-center gap-2 gap-xxl-3">
                            <div class="badge p-2 bg-label-success rounded">
                                <svg width="38" height="23" viewBox="0 0 38 23" fill="none"
                                    xmlns="http://www.w3.org/2000/svg">
                                    <path
                                        d="M26.2859 0C27.6056 0 28.6755 1.05369 28.6755 2.35346L28.675 3.09574L28.8083 3.09639L28.8085 2.8493C28.8085 1.98279 29.5217 1.28032 30.4016 1.28032C30.7084 1.28032 31.0088 1.36761 31.2665 1.53168L36.7716 5.03662C37.5105 5.50704 37.7222 6.47834 37.2446 7.20604C37.1222 7.39254 36.961 7.55131 36.7716 7.67187L31.2665 11.1768C30.5276 11.6472 29.5414 11.4387 29.0637 10.711C28.8971 10.4572 28.8085 10.1614 28.8085 9.85977L28.8083 9.61151L28.675 9.61101L28.677 13.3151C30.6745 16.9455 28.9081 22.4823 23.377 22.7407L23.1257 22.7487C16.93 22.8692 14.3458 14.6504 19.4184 11.3452C19.946 11.0279 19.6914 11.1667 20.0368 10.9882C20.3737 10.814 19.9628 11.0188 20.732 10.6481C21.4724 10.3582 22.2801 10.1983 23.1255 10.1983C24.7606 10.2266 26.0798 10.7071 27.083 11.4651L27.0821 9.61101L19.9135 9.61183C19.0337 9.61183 18.3205 8.90939 18.3205 8.04288V4.66563C18.3205 3.79912 19.0337 3.09665 19.9135 3.09665L27.0821 3.09574L27.0825 2.35346C27.0825 1.9202 26.7258 1.56895 26.2859 1.56895H2.38964C1.94972 1.56895 1.59307 1.9202 1.59307 2.35346V16.4741C1.59307 16.9074 1.94972 17.2586 2.38964 17.2586L16.7767 17.259C16.8462 17.8071 16.9874 18.3333 17.1908 18.8282L2.38964 18.8276C1.06988 18.8276 0 17.7739 0 16.4741V2.35346C0 1.05369 1.06988 0 2.38964 0H26.2859ZM21.1302 19.26L20.0291 20.3331C20.7082 20.8516 21.527 21.2036 22.4205 21.3263V19.8035C21.9486 19.7088 21.5118 19.5203 21.1302 19.26ZM25.1207 19.2601C24.7391 19.5203 24.3023 19.7088 23.8305 19.8035V21.3263C24.7239 21.2036 25.5428 20.8516 26.2219 20.3331L25.1207 19.2601ZM28.1221 17.031H26.5666C26.4908 17.4764 26.3262 17.8926 26.0908 18.262L27.2001 19.3431C27.6947 18.678 28.0221 17.8877 28.1221 17.031ZM19.6844 17.031H18.1289C18.2289 17.8877 18.5563 18.678 19.0509 19.343L20.1602 18.262C19.9247 17.8926 19.7601 17.4763 19.6844 17.031ZM23.1256 14.4479C20.3941 14.4952 20.3937 18.4515 23.1255 18.4992C25.8569 18.4518 25.8573 14.4956 23.1256 14.4479ZM19.165 13.4561C18.6594 14.0849 18.3081 14.8367 18.1663 15.6569H19.7391C19.8434 15.2466 20.0243 14.8658 20.2661 14.5291L19.165 13.4561ZM27.086 13.4561L25.9849 14.5291C26.2267 14.8658 26.4077 15.2466 26.5119 15.6569H28.0846C27.9429 14.8367 27.5916 14.0849 27.086 13.4561ZM8.46558 13.3362C8.87367 13.3362 9.20449 13.6604 9.20449 14.0603C9.20449 14.4603 8.87367 14.7845 8.46558 14.7845H3.92511C3.51701 14.7845 3.18614 14.4603 3.18614 14.0603C3.18614 13.6604 3.51701 13.3362 3.92511 13.3362H8.46558ZM15.2804 13.3362C15.6885 13.3362 16.0193 13.6604 16.0193 14.0603C16.0193 14.4603 15.6885 14.7845 15.2804 14.7845H10.74C10.3319 14.7845 10.001 14.4603 10.001 14.0603C10.001 13.6604 10.3319 13.3362 10.74 13.3362H15.2804ZM22.4205 11.6208C21.5926 11.7345 20.8288 12.0453 20.181 12.5028L21.2903 13.5838C21.6324 13.3767 22.0134 13.2252 22.4205 13.1435V11.6208ZM23.8305 11.6208V13.1436C24.2376 13.2253 24.6186 13.3768 24.9607 13.5838L26.0701 12.5028C25.4222 12.0453 24.6584 11.7345 23.8305 11.6208ZM30.4016 2.8493L30.4003 4.66529L19.9135 4.66563V8.04288L30.4003 8.04248L30.4016 9.85921L35.9067 6.35424L30.4016 2.8493ZM7.16891 3.13794C8.04874 3.13794 8.76198 3.84037 8.76198 4.70689C8.76198 5.57341 8.04874 6.27587 7.16891 6.27587C6.69284 6.27587 6.26552 6.0702 5.9736 5.74416C5.68263 6.0702 5.25534 6.27587 4.77927 6.27587C3.89944 6.27587 3.18614 5.57341 3.18614 4.70689C3.18614 3.84037 3.89944 3.13794 4.77927 3.13794C5.25534 3.13794 5.6826 3.34358 5.97453 3.66962C6.2655 3.34358 6.69284 3.13794 7.16891 3.13794Z"
                                        fill="#219653" />
                                </svg>

                            </div>
                            <div class="d-flex flex-column">
                                <h5 class="text-black fs-16 fw-semi-bold text-uppercase mb-1">{{ localize('Deposits') }}
                                </h5>
                                <span class="fs-13 text-muted fw-medium">{{ localize('Total deposit') }}</span>
                            </div>
                        </div>
                        <div class="d-flex align-items-center gap-2">
                            <h3 class="text-black fs-20 mb-2 mt-1 fw-semi-bold">
                                ${{ number_format($depositReport->totalTxnAmount, 2, '.', '') }}</h3>
                            <div id="depositChart"></div>
                        </div>
                        <div class="pt-2">
                            <div class="d-flex align-items-center gap-4">
                                <span class="fs-13 text-muted fw-medium">{{ $currentMonthYear }}</span>
                                <span
                                    class="fs-13 @if ($depositReport->currentMonthData > 0) text-success
                                @else text-black @endif fw-semi-bold">+${{ number_format($depositReport->currentMonthData, 2, '.', '') }}</span>
                                <span
                                    class="badge @if ($depositReport->percentageDifference > 0) bg-label-success
                                @else bg-label-danger @endif rounded-pill">{{ $depositReport->percentageDifference }}%</span>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- ETHUSDT Balance -->
            <div class="col-md-6 col-lg-4 col-xl-3">
                <div class="card shadow-none radius-12">
                    <div class="card-body">
                        <div class="d-flex align-items-center gap-2 gap-xxl-3">
                            <div class="badge p-2 bg-label-danger rounded">
                                <svg width="38" height="23" viewBox="0 0 38 23" fill="none"
                                    xmlns="http://www.w3.org/2000/svg">
                                    <path
                                        d="M27.6002 0C28.9859 0 30.1093 1.05369 30.1093 2.35346L30.1088 3.09574L35.8273 3.09665C36.7049 3.09665 37.4247 3.73063 37.4944 4.53695L37.5 4.66563V8.04288C37.5 8.90939 36.7511 9.61183 35.8273 9.61183L30.1088 9.61101L30.1109 13.3151C32.2082 16.9455 30.3535 22.4823 24.5459 22.7407L24.282 22.7487C17.7765 22.8692 15.0631 14.6504 20.3894 11.3452C20.9433 11.0279 20.676 11.1667 21.0386 10.9882C21.3924 10.814 20.961 11.0188 21.7686 10.6481C22.0417 10.5462 22.3235 10.4604 22.6127 10.392L18.1263 7.67187C17.9275 7.55131 17.7582 7.39254 17.6297 7.20604C17.1281 6.47834 17.3505 5.50704 18.1263 5.03662L23.8444 1.56887L2.50912 1.56895C2.0472 1.56895 1.67273 1.9202 1.67273 2.35346V16.4741C1.67273 16.9074 2.0472 17.2586 2.50912 17.2586L17.6155 17.259C17.6885 17.8071 17.8367 18.3333 18.0504 18.8282L2.50912 18.8276C1.12337 18.8276 0 17.7739 0 16.4741V2.35346C0 1.05369 1.12337 0 2.50912 0H27.6002ZM22.1867 19.26L21.0306 20.3331C21.7436 20.8516 22.6034 21.2036 23.5415 21.3263V19.8035C23.0461 19.7088 22.5874 19.5203 22.1867 19.26ZM26.3767 19.2601C25.976 19.5203 25.5174 19.7088 25.022 19.8035V21.3263C25.9601 21.2036 26.8199 20.8516 27.5329 20.3331L26.3767 19.2601ZM29.5282 17.031H27.8949C27.8154 17.4764 27.6425 17.8926 27.3953 18.262L28.5601 19.3431C29.0794 18.678 29.4232 17.8877 29.5282 17.031ZM20.6686 17.031H19.0353C19.1403 17.8877 19.4841 18.678 20.0034 19.343L21.1682 18.262C20.9209 17.8926 20.7481 17.4763 20.6686 17.031ZM24.2818 14.4479C21.4138 14.4952 21.4134 18.4515 24.2818 18.4992C27.1498 18.4518 27.1502 14.4956 24.2818 14.4479ZM20.1232 13.4561C19.5924 14.0849 19.2235 14.8367 19.0746 15.6569H20.7261C20.8355 15.2466 21.0255 14.8658 21.2794 14.5291L20.1232 13.4561ZM28.4403 13.4561L27.2841 14.5291C27.5381 14.8658 27.7281 15.2466 27.8375 15.6569H29.4888C29.34 14.8367 28.9711 14.0849 28.4403 13.4561ZM8.88885 13.3362C9.31735 13.3362 9.66471 13.6604 9.66471 14.0603C9.66471 14.4603 9.31735 14.7845 8.88885 14.7845H4.12136C3.69286 14.7845 3.34545 14.4603 3.34545 14.0603C3.34545 13.6604 3.69286 13.3362 4.12136 13.3362H8.88885ZM16.0444 13.3362C16.4729 13.3362 16.8203 13.6604 16.8203 14.0603C16.8203 14.4603 16.4729 14.7845 16.0444 14.7845H11.277C10.8485 14.7845 10.5011 14.4603 10.5011 14.0603C10.5011 13.6604 10.8485 13.3362 11.277 13.3362H16.0444ZM23.5415 11.6208C22.6722 11.7345 21.8703 12.0453 21.19 12.5028L22.3548 13.5838C22.714 13.3767 23.1141 13.2252 23.5415 13.1435V11.6208ZM25.022 11.6208V13.1436C25.4494 13.2253 25.8496 13.3768 26.2087 13.5838L27.3736 12.5028C26.6933 12.0453 25.8913 11.7345 25.022 11.6208ZM28.4362 9.61101L26.4878 9.61151L26.4876 9.85977C26.4876 10.0747 26.4403 10.2867 26.3498 10.4826C27.1492 10.7012 27.8455 11.0394 28.4371 11.4651L28.4362 9.61101ZM24.8149 2.8493L19.0344 6.35424L24.8149 9.85921L24.8162 8.04248L35.8273 8.04288V4.66563L24.8162 4.66529L24.8149 2.8493ZM7.52735 3.13794C8.45118 3.13794 9.20008 3.84037 9.20008 4.70689C9.20008 5.57341 8.45118 6.27587 7.52735 6.27587C7.02748 6.27587 6.5788 6.0702 6.27228 5.74416C5.96676 6.0702 5.51811 6.27587 5.01823 6.27587C4.09441 6.27587 3.34545 5.57341 3.34545 4.70689C3.34545 3.84037 4.09441 3.13794 5.01823 3.13794C5.51811 3.13794 5.96673 3.34358 6.27325 3.66962C6.57877 3.34358 7.02748 3.13794 7.52735 3.13794ZM27.6002 1.56895L25.7815 1.56866C26.2087 1.85291 26.4876 2.32058 26.4876 2.8493L26.4878 3.09639L28.4362 3.09574L28.4366 2.35346C28.4366 1.9202 28.0621 1.56895 27.6002 1.56895Z"
                                        fill="#FF0000" />
                                </svg>


                            </div>
                            <div class="d-flex flex-column">
                                <h5 class="text-black fs-16 fw-semi-bold text-uppercase mb-1">
                                    {{ localize('Withdrawals') }}
                                </h5>
                                <span class="fs-13 text-muted fw-medium">{{ localize('Total Withdraw') }}</span>
                            </div>
                        </div>
                        <div class="d-flex align-items-center gap-2">
                            <h3 class="text-black fs-20 mb-2 mt-1 fw-semi-bold">
                                ${{ number_format($withdrawReport->totalTxnAmount, 2, '.', '') }}</h3>
                            <div id="withdrawChart"></div>
                        </div>
                        <div class="pt-2">
                            <div class="d-flex align-items-center gap-4">
                                <span class="fs-13 text-muted fw-medium">{{ $currentMonthYear }}</span>
                                <span
                                    class="fs-13 @if ($withdrawReport->currentMonthData > 0) text-danger
                                @else text-black @endif fw-semi-bold">-${{ number_format($withdrawReport->currentMonthData, 2, '.', '') }}</span>
                                <span
                                    class="badge @if ($withdrawReport->percentageDifference > 0) bg-label-danger
                                @else bg-label-success @endif rounded-pill">{{ $withdrawReport->percentageDifference }}%</span>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <!--/ ETHUSDT Balance -->
            <!-- SOLUSDT Balance -->
            <div class="col-md-6 col-lg-4 col-xl-3">
                <div class="card shadow-none radius-12">
                    <div class="card-body">
                        <div class="d-flex align-items-center gap-2 gap-xxl-3">
                            <div class="badge p-2 bg-label-violate rounded">
                                <svg width="25" height="27" viewBox="0 0 25 27" fill="none"
                                    xmlns="http://www.w3.org/2000/svg">
                                    <path
                                        d="M24.4739 9.10269V18.33C24.4734 18.5559 24.3735 18.7725 24.196 18.9322C24.0185 19.092 23.7779 19.1819 23.5269 19.1824H1.44093C1.18993 19.1819 0.949361 19.092 0.771878 18.9322C0.594396 18.7725 0.494454 18.5559 0.493927 18.33V9.10269C0.494454 8.87677 0.594396 8.66024 0.771878 8.50049C0.949361 8.34074 1.18993 8.25078 1.44093 8.2503H23.5269C23.7779 8.25078 24.0185 8.34074 24.196 8.50049C24.3735 8.66024 24.4734 8.87677 24.4739 9.10269ZM17.3326 13.7146C17.3306 12.6363 16.8839 11.5971 16.0789 10.7986C15.274 10.0001 14.1682 9.49906 12.9762 9.3928C11.7841 9.28654 10.5906 9.58258 9.62729 10.2235C8.66396 10.8644 7.99943 11.8045 7.76259 12.8615C7.52575 13.9184 7.73349 15.0169 8.3455 15.9438C8.95751 16.8707 9.93018 17.56 11.0748 17.8779C12.2195 18.1959 13.4546 18.1198 14.5404 17.6646C15.6263 17.2093 16.4857 16.4072 16.9518 15.4139C17.2035 14.8767 17.3323 14.2994 17.3306 13.7163L17.3326 13.7146ZM16.864 5.49395C16.6569 5.68013 16.3762 5.78471 16.0835 5.78471C15.7908 5.78471 15.5101 5.68013 15.303 5.49395L13.5884 3.95069V5.74519C13.5884 6.00885 13.4721 6.26172 13.2649 6.44816C13.0578 6.6346 12.7769 6.73934 12.4839 6.73934C12.191 6.73934 11.9101 6.6346 11.7029 6.44816C11.4958 6.26172 11.3794 6.00885 11.3794 5.74519V3.95069L9.66486 5.49395C9.45759 5.68028 9.17657 5.78486 8.88363 5.7847C8.59069 5.78453 8.30982 5.67962 8.10281 5.49306C7.8958 5.30649 7.77961 5.05355 7.7798 4.78988C7.77999 4.5262 7.89654 4.2734 8.10381 4.08707L11.7024 0.847999C11.805 0.755542 11.9268 0.682194 12.0609 0.63215C12.195 0.582105 12.3388 0.556347 12.4839 0.556347C12.6291 0.556347 12.7728 0.582105 12.9069 0.63215C13.041 0.682194 13.1629 0.755542 13.2655 0.847999L16.864 4.08527C16.9668 4.17761 17.0483 4.28726 17.1039 4.40796C17.1595 4.52867 17.1881 4.65805 17.1881 4.78872C17.1881 4.91938 17.1595 5.04877 17.1039 5.16947C17.0483 5.29017 16.9668 5.40162 16.864 5.49395ZM16.864 23.3438L13.2655 26.5847C13.1629 26.6771 13.041 26.7505 12.9069 26.8005C12.7728 26.8506 12.6291 26.8763 12.4839 26.8763C12.3388 26.8763 12.195 26.8506 12.0609 26.8005C11.9268 26.7505 11.805 26.6771 11.7024 26.5847L8.10381 23.3438C7.90855 23.1554 7.80219 22.9061 7.80717 22.6484C7.81216 22.3908 7.92808 22.145 8.13051 21.9628C8.33294 21.7806 8.60606 21.6762 8.89229 21.6717C9.17853 21.6673 9.45551 21.763 9.66486 21.9387L11.3794 23.482V21.6875C11.3794 21.4238 11.4958 21.171 11.7029 20.9845C11.9101 20.7981 12.191 20.6934 12.4839 20.6934C12.7769 20.6934 13.0578 20.7981 13.2649 20.9845C13.4721 21.171 13.5884 21.4238 13.5884 21.6875V23.482L15.303 21.9387C15.4041 21.8411 15.5261 21.7629 15.6615 21.7086C15.797 21.6543 15.9432 21.6251 16.0915 21.6228C16.2397 21.6205 16.387 21.6451 16.5245 21.6951C16.662 21.7451 16.7868 21.8195 16.8917 21.9139C16.9965 22.0082 17.0792 22.1206 17.1348 22.2444C17.1903 22.3681 17.2176 22.5007 17.215 22.6341C17.2124 22.7676 17.18 22.8992 17.1197 23.0211C17.0594 23.143 16.9725 23.2528 16.864 23.3438ZM14.7707 14.8576C14.7695 15.1184 14.6923 15.3743 14.5467 15.5998C14.4012 15.8253 14.1924 16.0124 13.9413 16.1425C13.6884 16.2873 13.4099 16.3922 13.1179 16.453V16.9303C13.1089 17.0754 13.0384 17.2119 12.9211 17.3117C12.8037 17.4116 12.6484 17.4672 12.4869 17.4672C12.3254 17.4672 12.1701 17.4116 12.0528 17.3117C11.9354 17.2119 11.865 17.0754 11.8559 16.9303V16.4601C11.6728 16.4256 11.4939 16.3751 11.3216 16.3094C11.042 16.2054 10.7945 16.0423 10.5999 15.8339C10.4954 15.7193 10.4448 15.5725 10.4588 15.4248C10.4727 15.2771 10.5502 15.1402 10.6747 15.0431C10.7991 14.946 10.9608 14.8965 11.1252 14.9051C11.2896 14.9137 11.4437 14.9798 11.5549 15.0891C11.6177 15.1601 11.6983 15.2167 11.7901 15.2542C11.894 15.2951 12.0022 15.3263 12.1131 15.3475C12.2289 15.3682 12.3461 15.3814 12.464 15.387C12.7429 15.3876 13.0167 15.3193 13.2555 15.1896C13.5087 15.0425 13.5087 14.9169 13.5087 14.8576C13.5075 14.7653 13.4701 14.6763 13.403 14.6064C13.3278 14.5301 13.2389 14.4658 13.1398 14.4162C13.037 14.369 12.9278 14.334 12.8149 14.3121C12.71 14.2919 12.6031 14.2817 12.4959 14.2816C12.3136 14.2827 12.1316 14.2701 11.9516 14.2439C11.7077 14.2075 11.4712 14.1386 11.2498 14.0394C10.9916 13.923 10.7639 13.7585 10.582 13.5566C10.3304 13.2827 10.1911 12.9394 10.1872 12.584C10.193 12.3143 10.2759 12.0505 10.4277 11.8179C10.5796 11.5853 10.7955 11.3918 11.0545 11.2561C11.3015 11.118 11.5724 11.018 11.8559 10.96V10.5024C11.865 10.3573 11.9354 10.2208 12.0528 10.121C12.1701 10.0211 12.3254 9.96548 12.4869 9.96548C12.6484 9.96548 12.8037 10.0211 12.9211 10.121C13.0384 10.2208 13.1089 10.3573 13.1179 10.5024V10.9761C13.305 11.0172 13.4872 11.0743 13.6622 11.1466C13.8978 11.2419 14.1125 11.3744 14.2962 11.5378C14.4149 11.6444 14.4817 11.7891 14.4819 11.9401C14.4821 12.091 14.4156 12.2358 14.2972 12.3427C14.1787 12.4495 14.018 12.5096 13.8503 12.5098C13.6826 12.51 13.5217 12.4502 13.403 12.3436C13.3278 12.2765 13.2401 12.2218 13.1438 12.182C13.037 12.1375 12.9254 12.1026 12.8109 12.078L12.777 12.0708C12.6874 12.0503 12.596 12.0365 12.5039 12.0295C12.2315 12.0285 11.9638 12.093 11.7283 12.2161C11.6501 12.2501 11.5832 12.302 11.5342 12.3665C11.4852 12.4311 11.4559 12.5061 11.4492 12.584C11.455 12.6784 11.4949 12.7685 11.5628 12.8406C11.6318 12.916 11.7173 12.9777 11.8141 13.0219C11.923 13.0703 12.0392 13.1041 12.159 13.1224C12.2703 13.1386 12.3831 13.1464 12.4959 13.1457C12.6935 13.1448 12.8907 13.1629 13.084 13.1995C13.308 13.2437 13.5245 13.3143 13.728 13.4095C13.9647 13.5242 14.1767 13.6761 14.354 13.8581C14.6232 14.1348 14.7699 14.4899 14.7707 14.8576Z"
                                        fill="#9181DB" />
                                </svg>

                            </div>
                            <div class="d-flex flex-column">
                                <h5 class="text-black fs-16 fw-semi-bold text-uppercase mb-1">
                                    {{ localize('Transfers') }}
                                </h5>
                                <span class="fs-13 text-muted fw-medium">{{ localize('Total Transfer') }}</span>
                            </div>
                        </div>
                        <div class="d-flex align-items-center gap-2">
                            <h3 class="text-black fs-20 mb-2 mt-1 fw-semi-bold">
                                ${{ number_format($transferReport->totalTxnAmount, 2, '.', '') }}</h3>
                            <div id="transferChart"></div>
                        </div>
                        <div class="pt-2">
                            <div class="d-flex align-items-center gap-4">
                                <span class="fs-13 text-muted fw-medium">{{ $currentMonthYear }}</span>
                                <span
                                    class="fs-13 @if ($transferReport->currentMonthData > 0) text-success
                                @else text-black @endif fw-semi-bold">${{ number_format($transferReport->currentMonthData, 2, '.', '') }}</span>
                                <span
                                    class="badge @if ($transferReport->percentageDifference > 0) bg-label-success
                                @else bg-label-danger @endif rounded-pill">{{ $transferReport->percentageDifference }}%</span>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <!--/ SOLUSDT Balance -->
            <!-- BTCUSDT Balance -->
            <div class="col-md-6 col-lg-4 col-xl-3">
                <div class="card shadow-none radius-12">
                    <div class="card-body">
                        <div class="d-flex align-items-center gap-2 gap-xxl-3">
                            <div class="badge p-2 bg-label-success rounded">
                                <svg width="27" height="23" viewBox="0 0 27 23" fill="none"
                                    xmlns="http://www.w3.org/2000/svg">
                                    <path
                                        d="M24.3053 4.17818H17.25V1.56957C17.25 0.606166 16.4166 0 15.391 0C15.391 0 11.4806 0 11.5019 0C10.4976 0 9.64286 0.606166 9.64286 1.56957V4.28813H2.69625C1.3005 4.28813 0 5.50376 0 7.11017C0 7.1536 0 20.0371 0 20.0371C0 21.828 1.30404 22.98 2.67857 22.98H24.3159C25.6843 22.98 27 21.9257 27 20.1135C27 20.1135 27 7.08851 27 7.03353C26.9895 5.40822 25.6948 4.17818 24.3053 4.17818ZM11.0357 1.53933H15.8571V4.28813H11.0357V1.53933ZM13.4916 19.2801C10.3962 19.2801 7.88325 16.7013 7.88325 13.5247C7.88325 10.331 10.3796 7.73513 13.4916 7.73513C16.6037 7.73513 19.1166 10.314 19.1166 13.5076C19.1166 16.7013 16.5871 19.2801 13.4916 19.2801ZM15.5885 14.7999C15.5885 15.705 15.0505 16.3939 13.9132 16.6558V17.5609H13.1366V16.6842C12.4653 16.6842 11.7886 16.5021 11.4613 16.3143L11.7441 15.1472C12.1047 15.3294 12.6705 15.5457 13.2696 15.5457C13.9131 15.5457 14.2293 15.2553 14.2293 14.8568C14.2293 14.4584 13.9242 14.2932 13.1809 13.9972C12.1491 13.6272 11.5056 13.0921 11.5056 12.1414C11.5056 11.2647 12.0715 10.5759 13.1088 10.3595V9.40883H13.8855V10.314C14.529 10.314 14.995 10.4506 15.3389 10.6384L15.0227 11.777C14.7675 11.6688 14.3515 11.4866 13.7801 11.4866C13.2087 11.4866 12.8981 11.777 12.8981 12.0672C12.8981 12.4657 13.2586 12.6194 14.0353 12.9439C15.0948 13.3426 15.5885 13.8948 15.5885 14.7999Z"
                                        fill="#219653" />
                                </svg>

                            </div>
                            <div class="d-flex flex-column">
                                <h5 class="text-black fs-16 fw-semi-bold text-uppercase mb-1">
                                    {{ localize('Investments') }}</h5>
                                <span class="fs-13 text-muted fw-medium">{{ localize('Total Investment') }}</span>
                            </div>
                        </div>
                        <div class="d-flex align-items-center gap-2">
                            <h3 class="text-black fs-20 mb-2 mt-1 fw-semi-bold">
                                ${{ number_format($investmentReport->totalTxnAmount, 2, '.', '') }}</h3>
                            <div id="investmentChart"></div>
                        </div>
                        <div class="pt-2">
                            <div class="d-flex align-items-center gap-4">
                                <span class="fs-13 text-muted fw-medium">{{ $currentMonthYear }}</span>
                                <span
                                    class="fs-13 @if ($investmentReport->currentMonthData > 0) text-success
                                @else text-black @endif fw-semi-bold">${{ number_format($investmentReport->currentMonthData, 2, '.', '') }}</span>
                                <span
                                    class="badge @if ($investmentReport->percentageDifference > 0) bg-label-success
                                @else bg-label-danger @endif rounded-pill">{{ $investmentReport->percentageDifference }}%</span>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <!--/ BTCUSDT Balance -->
            <!-- BTCUSDT Balance -->
            <div class="col-md-6 col-lg-4 col-xl-3">
                <div class="card shadow-none radius-12">
                    <div class="card-body">
                        <div class="d-flex align-items-center gap-2 gap-xxl-3">
                            <div class="badge p-2 bg-label-warning rounded">
                                <svg width="27" height="27" viewBox="0 0 27 27" fill="none"
                                    xmlns="http://www.w3.org/2000/svg">
                                    <path
                                        d="M27 18.6317C27 17.203 25.8297 16.0399 24.3911 16.0399C23.8537 16.0399 23.3558 16.2067 22.9424 16.4823H22.9407C22.9407 16.4848 22.939 16.4848 22.939 16.4865C22.7644 16.6055 22.6032 16.7387 22.4615 16.8929L22.4682 16.8996C21.9274 17.3823 21.0625 18.1926 20.4348 18.93C20.2998 18.5847 20.0939 18.2705 19.8298 18.0141C17.2538 15.7617 14.1573 14.8467 10.6076 14.8467C9.44578 14.8467 8.32528 14.9715 7.26553 15.202C7.23431 14.819 7.21238 14.5861 7.21238 14.5861H0.302906C0.302906 14.5861 0 17.0982 0 20.1953C0 23.2931 0.302906 25.8045 0.302906 25.8045H7.21238C7.21238 25.8045 7.27312 25.1509 7.33894 24.2182C8.36747 24.0465 9.41878 24.3154 10.6363 25.0662C12.1787 26.0676 14.0788 26.66 16.1359 26.66C18.2216 26.66 20.0121 26.0491 21.5021 25.0218L21.5038 25.0235C21.5198 25.0109 21.5384 24.9975 21.5612 24.9799C21.9831 24.6841 22.3822 24.359 22.7534 24.0012C23.0462 23.7046 23.4402 23.325 24.0351 22.7485C26.0272 20.8044 26.2727 20.4182 26.2727 20.4182C26.2727 20.4182 26.2668 20.4198 26.2651 20.4198C26.7199 19.9573 27 19.3288 27 18.6317ZM25.4146 19.6481C25.0653 19.9916 23.587 21.5041 23.1879 21.8921C22.151 22.9035 21.6683 23.3761 21.4397 23.6384L21.4363 23.6333C21.2777 23.7741 21.1115 23.9032 20.9419 24.0272C19.6054 24.9246 17.9407 25.4609 16.1367 25.4609C14.3159 25.4609 12.6385 24.9188 11.297 24.0071H11.2868C10.1267 23.3024 8.76572 22.8725 7.41909 23.0041C7.47225 22.0798 7.51612 21.0667 7.51612 20.1978C7.51612 18.9911 7.43175 17.5071 7.35328 16.3709C8.37844 16.1413 9.47278 16.0122 10.6076 16.0122C14.0839 16.0122 17.1568 17.1535 19.0409 18.9409C19.2628 19.1864 19.4029 19.5098 19.4029 19.8634C19.4029 20.631 18.7751 21.2527 18.0039 21.2527C17.9744 21.2527 17.9474 21.2452 17.917 21.2435L17.9137 21.2611C17.1931 21.236 16.0675 20.9352 14.1657 20.2137L13.7329 21.3365C15.7444 22.0991 17.0682 22.441 18.0073 22.4653V22.4569C19.1843 22.4527 20.1774 21.6751 20.5006 20.6126V20.6142C20.9073 19.943 22.4302 18.5428 23.2951 17.7795L23.2968 17.7811C23.3061 17.7719 23.3145 17.7652 23.3196 17.7594C23.4799 17.6161 23.6183 17.4971 23.7187 17.4108C23.9009 17.2968 24.0899 17.2491 24.392 17.2491C25.1632 17.2491 25.7884 17.8725 25.7884 18.6367C25.7884 19.0163 25.6188 19.3791 25.4146 19.6481Z"
                                        fill="#FFB849" />
                                    <path
                                        d="M18.5398 15.5179C22.8472 15.5179 26.353 12.0379 26.353 7.75935C26.353 3.48082 22.8497 0 18.5398 0C14.2317 0 10.7267 3.48082 10.7267 7.75935C10.7267 12.0379 14.23 15.5179 18.5398 15.5179ZM18.5398 1.35244C22.0963 1.35244 24.9912 4.22826 24.9912 7.75935C24.9912 11.2904 22.0954 14.1663 18.5398 14.1663C14.9818 14.1663 12.0885 11.2904 12.0885 7.75935C12.0885 4.22742 14.9818 1.35244 18.5398 1.35244Z"
                                        fill="#FFB849" />
                                    <path
                                        d="M16.491 7.49792C16.6573 7.69064 16.896 7.86745 17.2065 8.03169C17.5145 8.19341 17.9279 8.31491 18.4443 8.392C18.5911 8.4163 18.7379 8.44731 18.8839 8.48836C19.0341 8.52607 19.1691 8.5797 19.294 8.6459C19.4172 8.71293 19.5201 8.79338 19.5986 8.88639C19.6779 8.97772 19.7175 9.08917 19.7175 9.2157C19.7175 9.36653 19.6416 9.48719 19.4897 9.58272C19.3345 9.67573 19.1472 9.72182 18.9143 9.72182C18.7379 9.72182 18.5802 9.70841 18.4426 9.68076C18.3093 9.65478 18.1819 9.61205 18.0722 9.55507C17.9608 9.49809 17.8512 9.42602 17.744 9.3372C17.6385 9.25005 17.5297 9.14699 17.4192 9.02632H16.1451V10.9251H17.4192V10.6419C17.4799 10.6729 17.5423 10.7022 17.609 10.729C17.6698 10.7567 17.7356 10.7843 17.8022 10.8145V11.5561H19.0763V10.9854C19.3497 10.9678 19.6036 10.91 19.8357 10.8137C20.0694 10.719 20.2727 10.5908 20.4423 10.4341C20.6119 10.2782 20.7452 10.0955 20.8431 9.88773C20.941 9.67992 20.9899 9.45535 20.9899 9.21486C20.9899 9.08917 20.9688 8.92493 20.9207 8.72215C20.876 8.52104 20.7705 8.31491 20.6077 8.1071C20.4465 7.89929 20.2052 7.7074 19.8939 7.52976C19.5808 7.35128 19.1607 7.22391 18.6333 7.14514C17.7828 7.01945 17.3593 6.76053 17.3593 6.36921C17.3593 6.23011 17.4251 6.10107 17.5618 5.97956C17.6984 5.85974 17.8959 5.79941 18.1482 5.79941C18.3245 5.79941 18.4781 5.81449 18.608 5.84382C18.7379 5.87482 18.8586 5.91923 18.9674 5.97454C19.0763 6.03152 19.1801 6.10358 19.2771 6.1924C19.3741 6.27955 19.4728 6.38094 19.5766 6.4949H20.8591V4.59612H19.5868V4.86678C19.4349 4.77544 19.2636 4.70338 19.0763 4.64891V3.9618H17.8031V4.55925C17.5542 4.59528 17.3272 4.66735 17.1179 4.77209C16.9087 4.87683 16.7273 5.00923 16.5729 5.17011C16.4168 5.32848 16.2978 5.51199 16.2126 5.71645C16.1257 5.92091 16.0852 6.1371 16.0852 6.36753C16.0852 6.52339 16.1113 6.70271 16.1628 6.90465C16.216 7.10576 16.3248 7.30519 16.491 7.49792Z"
                                        fill="#FFB849" />
                                </svg>

                            </div>
                            <div class="d-flex flex-column">
                                <h5 class="text-black fs-16 fw-semi-bold text-uppercase mb-1">
                                    {{ localize('Deposit Fees') }}</h5>
                                <span class="fs-13 text-muted fw-medium">{{ localize('Total Deposit Fee') }}</span>
                            </div>
                        </div>
                        <div class="d-flex align-items-center gap-2">
                            <h3 class="text-black fs-20 mb-2 mt-1 fw-semi-bold">
                                ${{ number_format($depositFeeReport->totalTxnAmount, 2, '.', '') }}</h3>
                            <div id="depositFeesChart"></div>
                        </div>
                        <div class="pt-2">
                            <div class="d-flex align-items-center gap-4">
                                <span class="fs-13 text-muted fw-medium">{{ $currentMonthYear }}</span>
                                <span
                                    class="fs-13 @if ($depositFeeReport->currentMonthData > 0) text-success
                                @else text-black @endif fw-semi-bold">+${{ number_format($depositFeeReport->currentMonthData, 2, '.', '') }}</span>
                                <span
                                    class="badge @if ($depositFeeReport->percentageDifference > 0) bg-label-success
                                @else bg-label-danger @endif rounded-pill">{{ $depositFeeReport->percentageDifference }}%</span>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <!--/ BTCUSDT Balance -->
            <!-- ETHUSDT Balance -->
            <div class="col-md-6 col-lg-4 col-xl-3">
                <div class="card shadow-none radius-12">
                    <div class="card-body">
                        <div class="d-flex align-items-center gap-2 gap-xxl-3">
                            <div class="badge p-2 bg-label-violate rounded">
                                <svg width="27" height="27" viewBox="0 0 27 27" fill="none"
                                    xmlns="http://www.w3.org/2000/svg">
                                    <path
                                        d="M27 18.6317C27 17.203 25.8297 16.0399 24.3911 16.0399C23.8537 16.0399 23.3558 16.2067 22.9424 16.4823H22.9407C22.9407 16.4848 22.939 16.4848 22.939 16.4865C22.7644 16.6055 22.6032 16.7387 22.4615 16.8929L22.4682 16.8996C21.9274 17.3823 21.0625 18.1926 20.4348 18.93C20.2998 18.5847 20.0939 18.2705 19.8298 18.0141C17.2538 15.7617 14.1573 14.8467 10.6076 14.8467C9.44578 14.8467 8.32528 14.9715 7.26553 15.202C7.23431 14.819 7.21238 14.5861 7.21238 14.5861H0.302906C0.302906 14.5861 0 17.0982 0 20.1953C0 23.2931 0.302906 25.8045 0.302906 25.8045H7.21238C7.21238 25.8045 7.27312 25.1509 7.33894 24.2182C8.36747 24.0465 9.41878 24.3154 10.6363 25.0662C12.1787 26.0676 14.0788 26.66 16.1359 26.66C18.2216 26.66 20.0121 26.0491 21.5021 25.0218L21.5038 25.0235C21.5198 25.0109 21.5384 24.9975 21.5612 24.9799C21.9831 24.6841 22.3822 24.359 22.7534 24.0012C23.0462 23.7046 23.4402 23.325 24.0351 22.7485C26.0272 20.8044 26.2727 20.4182 26.2727 20.4182C26.2727 20.4182 26.2668 20.4198 26.2651 20.4198C26.7199 19.9573 27 19.3288 27 18.6317ZM25.4146 19.6481C25.0653 19.9916 23.587 21.5041 23.1879 21.8921C22.151 22.9035 21.6683 23.3761 21.4397 23.6384L21.4363 23.6333C21.2777 23.7741 21.1115 23.9032 20.9419 24.0272C19.6054 24.9246 17.9407 25.4609 16.1367 25.4609C14.3159 25.4609 12.6385 24.9188 11.297 24.0071H11.2868C10.1267 23.3024 8.76572 22.8725 7.41909 23.0041C7.47225 22.0798 7.51612 21.0667 7.51612 20.1978C7.51612 18.9911 7.43175 17.5071 7.35328 16.3709C8.37844 16.1413 9.47278 16.0122 10.6076 16.0122C14.0839 16.0122 17.1568 17.1535 19.0409 18.9409C19.2628 19.1864 19.4029 19.5098 19.4029 19.8634C19.4029 20.631 18.7751 21.2527 18.0039 21.2527C17.9744 21.2527 17.9474 21.2452 17.917 21.2435L17.9137 21.2611C17.1931 21.236 16.0675 20.9352 14.1657 20.2137L13.7329 21.3365C15.7444 22.0991 17.0682 22.441 18.0073 22.4653V22.4569C19.1843 22.4527 20.1774 21.6751 20.5006 20.6126V20.6142C20.9073 19.943 22.4302 18.5428 23.2951 17.7795L23.2968 17.7811C23.3061 17.7719 23.3145 17.7652 23.3196 17.7594C23.4799 17.6161 23.6183 17.4971 23.7187 17.4108C23.9009 17.2968 24.0899 17.2491 24.392 17.2491C25.1632 17.2491 25.7884 17.8725 25.7884 18.6367C25.7884 19.0163 25.6188 19.3791 25.4146 19.6481Z"
                                        fill="#9181DB" />
                                    <path
                                        d="M18.5398 15.5179C22.8472 15.5179 26.353 12.0379 26.353 7.75935C26.353 3.48082 22.8497 0 18.5398 0C14.2317 0 10.7267 3.48082 10.7267 7.75935C10.7267 12.0379 14.23 15.5179 18.5398 15.5179ZM18.5398 1.35244C22.0963 1.35244 24.9912 4.22826 24.9912 7.75935C24.9912 11.2904 22.0954 14.1663 18.5398 14.1663C14.9818 14.1663 12.0885 11.2904 12.0885 7.75935C12.0885 4.22742 14.9818 1.35244 18.5398 1.35244Z"
                                        fill="#9181DB" />
                                    <path
                                        d="M16.491 7.49792C16.6573 7.69064 16.896 7.86745 17.2065 8.03169C17.5145 8.19341 17.9279 8.31491 18.4443 8.392C18.5911 8.4163 18.7379 8.44731 18.8839 8.48836C19.0341 8.52607 19.1691 8.5797 19.294 8.6459C19.4172 8.71293 19.5201 8.79338 19.5986 8.88639C19.6779 8.97772 19.7175 9.08917 19.7175 9.2157C19.7175 9.36653 19.6416 9.48719 19.4897 9.58272C19.3345 9.67573 19.1472 9.72182 18.9143 9.72182C18.7379 9.72182 18.5802 9.70841 18.4426 9.68076C18.3093 9.65478 18.1819 9.61205 18.0722 9.55507C17.9608 9.49809 17.8512 9.42602 17.744 9.3372C17.6385 9.25005 17.5297 9.14699 17.4192 9.02632H16.1451V10.9251H17.4192V10.6419C17.4799 10.6729 17.5423 10.7022 17.609 10.729C17.6698 10.7567 17.7356 10.7843 17.8022 10.8145V11.5561H19.0763V10.9854C19.3497 10.9678 19.6036 10.91 19.8357 10.8137C20.0694 10.719 20.2727 10.5908 20.4423 10.4341C20.6119 10.2782 20.7452 10.0955 20.8431 9.88773C20.941 9.67992 20.9899 9.45535 20.9899 9.21486C20.9899 9.08917 20.9688 8.92493 20.9207 8.72215C20.876 8.52104 20.7705 8.31491 20.6077 8.1071C20.4465 7.89929 20.2052 7.7074 19.8939 7.52976C19.5808 7.35128 19.1607 7.22391 18.6333 7.14514C17.7828 7.01945 17.3593 6.76053 17.3593 6.36921C17.3593 6.23011 17.4251 6.10107 17.5618 5.97956C17.6984 5.85974 17.8959 5.79941 18.1482 5.79941C18.3245 5.79941 18.4781 5.81449 18.608 5.84382C18.7379 5.87482 18.8586 5.91923 18.9674 5.97454C19.0763 6.03152 19.1801 6.10358 19.2771 6.1924C19.3741 6.27955 19.4728 6.38094 19.5766 6.4949H20.8591V4.59612H19.5868V4.86678C19.4349 4.77544 19.2636 4.70338 19.0763 4.64891V3.9618H17.8031V4.55925C17.5542 4.59528 17.3272 4.66735 17.1179 4.77209C16.9087 4.87683 16.7273 5.00923 16.5729 5.17011C16.4168 5.32848 16.2978 5.51199 16.2126 5.71645C16.1257 5.92091 16.0852 6.1371 16.0852 6.36753C16.0852 6.52339 16.1113 6.70271 16.1628 6.90465C16.216 7.10576 16.3248 7.30519 16.491 7.49792Z"
                                        fill="#9181DB" />
                                </svg>

                            </div>
                            <div class="d-flex flex-column">
                                <h5 class="text-black fs-16 fw-semi-bold text-uppercase mb-1">
                                    {{ localize('Withdrawal Fees') }}</h5>
                                <span class="fs-13 text-muted fw-medium">{{ localize('Total withdrawal fee') }}</span>
                            </div>
                        </div>
                        <div class="d-flex align-items-center gap-2">
                            <h3 class="text-black fs-20 mb-2 mt-1 fw-semi-bold">
                                ${{ number_format($withdrawFeeReport->totalTxnAmount, 2, '.', '') }}</h3>
                            <div id="withdrawFeesChart"></div>
                        </div>
                        <div class="pt-2">
                            <div class="d-flex align-items-center gap-4">
                                <span class="fs-13 text-muted fw-medium">{{ $currentMonthYear }}</span>
                                <span
                                    class="fs-13 @if ($withdrawFeeReport->currentMonthData > 0) text-success
                                @else text-black @endif fw-semi-bold">+${{ number_format($withdrawFeeReport->currentMonthData, 2, '.', '') }}</span>
                                <span
                                    class="badge @if ($withdrawFeeReport->percentageDifference > 0) bg-label-success
                                @else bg-label-danger @endif rounded-pill">{{ $withdrawFeeReport->percentageDifference }}%</span>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <!--/ ETHUSDT Balance -->
            <!-- SOLUSDT Balance -->
            <div class="col-md-6 col-lg-4 col-xl-3">
                <div class="card shadow-none radius-12">
                    <div class="card-body">
                        <div class="d-flex align-items-center gap-2 gap-xxl-3">
                            <div class="badge p-2 bg-label-danger rounded">
                                <svg width="27" height="27" viewBox="0 0 27 27" fill="none"
                                    xmlns="http://www.w3.org/2000/svg">
                                    <path
                                        d="M27 18.6317C27 17.203 25.8297 16.0399 24.3911 16.0399C23.8537 16.0399 23.3558 16.2067 22.9424 16.4823H22.9407C22.9407 16.4848 22.939 16.4848 22.939 16.4865C22.7644 16.6055 22.6032 16.7387 22.4615 16.8929L22.4682 16.8996C21.9274 17.3823 21.0625 18.1926 20.4348 18.93C20.2998 18.5847 20.0939 18.2705 19.8298 18.0141C17.2538 15.7617 14.1573 14.8467 10.6076 14.8467C9.44578 14.8467 8.32528 14.9715 7.26553 15.202C7.23431 14.819 7.21238 14.5861 7.21238 14.5861H0.302906C0.302906 14.5861 0 17.0982 0 20.1953C0 23.2931 0.302906 25.8045 0.302906 25.8045H7.21238C7.21238 25.8045 7.27312 25.1509 7.33894 24.2182C8.36747 24.0465 9.41878 24.3154 10.6363 25.0662C12.1787 26.0676 14.0788 26.66 16.1359 26.66C18.2216 26.66 20.0121 26.0491 21.5021 25.0218L21.5038 25.0235C21.5198 25.0109 21.5384 24.9975 21.5612 24.9799C21.9831 24.6841 22.3822 24.359 22.7534 24.0012C23.0462 23.7046 23.4402 23.325 24.0351 22.7485C26.0272 20.8044 26.2727 20.4182 26.2727 20.4182C26.2727 20.4182 26.2668 20.4198 26.2651 20.4198C26.7199 19.9573 27 19.3288 27 18.6317ZM25.4146 19.6481C25.0653 19.9916 23.587 21.5041 23.1879 21.8921C22.151 22.9035 21.6683 23.3761 21.4397 23.6384L21.4363 23.6333C21.2777 23.7741 21.1115 23.9032 20.9419 24.0272C19.6054 24.9246 17.9407 25.4609 16.1367 25.4609C14.3159 25.4609 12.6385 24.9188 11.297 24.0071H11.2868C10.1267 23.3024 8.76572 22.8725 7.41909 23.0041C7.47225 22.0798 7.51612 21.0667 7.51612 20.1978C7.51612 18.9911 7.43175 17.5071 7.35328 16.3709C8.37844 16.1413 9.47278 16.0122 10.6076 16.0122C14.0839 16.0122 17.1568 17.1535 19.0409 18.9409C19.2628 19.1864 19.4029 19.5098 19.4029 19.8634C19.4029 20.631 18.7751 21.2527 18.0039 21.2527C17.9744 21.2527 17.9474 21.2452 17.917 21.2435L17.9137 21.2611C17.1931 21.236 16.0675 20.9352 14.1657 20.2137L13.7329 21.3365C15.7444 22.0991 17.0682 22.441 18.0073 22.4653V22.4569C19.1843 22.4527 20.1774 21.6751 20.5006 20.6126V20.6142C20.9073 19.943 22.4302 18.5428 23.2951 17.7795L23.2968 17.7811C23.3061 17.7719 23.3145 17.7652 23.3196 17.7594C23.4799 17.6161 23.6183 17.4971 23.7187 17.4108C23.9009 17.2968 24.0899 17.2491 24.392 17.2491C25.1632 17.2491 25.7884 17.8725 25.7884 18.6367C25.7884 19.0163 25.6188 19.3791 25.4146 19.6481Z"
                                        fill="#FF0000" />
                                    <path
                                        d="M18.5398 15.5179C22.8472 15.5179 26.353 12.0379 26.353 7.75935C26.353 3.48082 22.8497 0 18.5398 0C14.2317 0 10.7267 3.48082 10.7267 7.75935C10.7267 12.0379 14.23 15.5179 18.5398 15.5179ZM18.5398 1.35244C22.0963 1.35244 24.9912 4.22826 24.9912 7.75935C24.9912 11.2904 22.0954 14.1663 18.5398 14.1663C14.9818 14.1663 12.0885 11.2904 12.0885 7.75935C12.0885 4.22742 14.9818 1.35244 18.5398 1.35244Z"
                                        fill="#FF0000" />
                                    <path
                                        d="M16.491 7.49792C16.6573 7.69064 16.896 7.86745 17.2065 8.03169C17.5145 8.19341 17.9279 8.31491 18.4443 8.392C18.5911 8.4163 18.7379 8.44731 18.8839 8.48836C19.0341 8.52607 19.1691 8.5797 19.294 8.6459C19.4172 8.71293 19.5201 8.79338 19.5986 8.88639C19.6779 8.97772 19.7175 9.08917 19.7175 9.2157C19.7175 9.36653 19.6416 9.48719 19.4897 9.58272C19.3345 9.67573 19.1472 9.72182 18.9143 9.72182C18.7379 9.72182 18.5802 9.70841 18.4426 9.68076C18.3093 9.65478 18.1819 9.61205 18.0722 9.55507C17.9608 9.49809 17.8512 9.42602 17.744 9.3372C17.6385 9.25005 17.5297 9.14699 17.4192 9.02632H16.1451V10.9251H17.4192V10.6419C17.4799 10.6729 17.5423 10.7022 17.609 10.729C17.6698 10.7567 17.7356 10.7843 17.8022 10.8145V11.5561H19.0763V10.9854C19.3497 10.9678 19.6036 10.91 19.8357 10.8137C20.0694 10.719 20.2727 10.5908 20.4423 10.4341C20.6119 10.2782 20.7452 10.0955 20.8431 9.88773C20.941 9.67992 20.9899 9.45535 20.9899 9.21486C20.9899 9.08917 20.9688 8.92493 20.9207 8.72215C20.876 8.52104 20.7705 8.31491 20.6077 8.1071C20.4465 7.89929 20.2052 7.7074 19.8939 7.52976C19.5808 7.35128 19.1607 7.22391 18.6333 7.14514C17.7828 7.01945 17.3593 6.76053 17.3593 6.36921C17.3593 6.23011 17.4251 6.10107 17.5618 5.97956C17.6984 5.85974 17.8959 5.79941 18.1482 5.79941C18.3245 5.79941 18.4781 5.81449 18.608 5.84382C18.7379 5.87482 18.8586 5.91923 18.9674 5.97454C19.0763 6.03152 19.1801 6.10358 19.2771 6.1924C19.3741 6.27955 19.4728 6.38094 19.5766 6.4949H20.8591V4.59612H19.5868V4.86678C19.4349 4.77544 19.2636 4.70338 19.0763 4.64891V3.9618H17.8031V4.55925C17.5542 4.59528 17.3272 4.66735 17.1179 4.77209C16.9087 4.87683 16.7273 5.00923 16.5729 5.17011C16.4168 5.32848 16.2978 5.51199 16.2126 5.71645C16.1257 5.92091 16.0852 6.1371 16.0852 6.36753C16.0852 6.52339 16.1113 6.70271 16.1628 6.90465C16.216 7.10576 16.3248 7.30519 16.491 7.49792Z"
                                        fill="#FF0000" />
                                </svg>

                            </div>
                            <div class="d-flex flex-column">
                                <h5 class="text-black fs-16 fw-semi-bold text-uppercase mb-1">
                                    {{ localize('Transfer Fees') }}</h5>
                                <span class="fs-13 text-muted fw-medium">{{ localize('Total transfer fee') }}</span>
                            </div>
                        </div>
                        <div class="d-flex align-items-center gap-2">
                            <h3 class="text-black fw-semi-bold fs-20 mb-2 mt-1">
                                ${{ number_format($transferFeeReport->totalTxnAmount, 2, '.', '') }}</h3>
                            <div id="transferFeesChart"></div>
                        </div>
                        <div class="pt-2">
                            <div class="d-flex align-items-center gap-4">
                                <span class="fs-13 text-muted fw-medium">{{ $currentMonthYear }}</span>
                                <span
                                    class="fs-13 @if ($transferFeeReport->currentMonthData > 0) text-success
                                @else text-black @endif fw-semi-bold">+${{ number_format($transferFeeReport->currentMonthData, 2, '.', '') }}</span>
                                <span
                                    class="badge @if ($transferFeeReport->percentageDifference > 0) bg-label-success
                                @else bg-label-danger @endif rounded-pill">{{ $transferFeeReport->percentageDifference }}%</span>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <!--/ SOLUSDT Balance -->
        </div>
        <div class="row g-3 mb-3">
            <div class="col-lg-8">
                <div class="card shadow-none radius-12">
                    <div class="card-body">
                        <div class="row">
                            <div class="col-lg-6 col-xxl-5">
                                <select class="custom-form-control basic-single" name="transactionType"
                                    id="transactionType" required>
                                    <option value="investment" selected>{{ localize('Investment') }}</option>
                                    <option value="deposit">{{ localize('Deposit') }}</option>
                                    <option value="withdraw">{{ localize('Withdraw') }}</option>
                                    <option value="transfer">{{ localize('Transfer') }}</option>
                                </select>
                            </div>
                            <div class="col-lg-6 col-xxl-7">
                                <div>
                                    <nav
                                        class="d-flex justify-content-center justify-content-lg-end gap-3 chat-time-range">
                                        <a href="javascript:void(0)" data-type="m"
                                            class="nav-link fw-semi-bold dataType active">{{ localize('Monthly') }}</a>
                                        <a href="javascript:void(0)" data-type="y"
                                            class="nav-link fw-semi-bold dataType">{{ localize('Yearly') }}</a>
                                    </nav>
                                </div>
                            </div>
                        </div>
                        <div id="chart"></div>
                    </div>
                </div>
            </div>
            <div class="col-lg-4">
                <div class="card shadow-none radius-12">
                    <div class="card-body">
                        <div class="d-flex align-items-center gap-3 mb-4">
                            <h2 class="mb-0 fs-20 text-black">{{ localize('Transactions') }}</h2>
                            <ul class="nav nav-pills dahboard-tab gap-1" role="tablist">
                                <li class="nav-item">
                                    <button type="button" class="nav-link active" role="tab"
                                        data-bs-toggle="tab" data-bs-target="#navs-pills-top-all"
                                        aria-controls="navs-pills-top-all" aria-selected="true">{{ localize('All') }}
                                    </button>
                                </li>
                                <li class="nav-item">
                                    <button type="button" class="nav-link" role="tab" data-bs-toggle="tab"
                                        data-bs-target="#navs-pills-top-metaverse"
                                        aria-controls="navs-pills-top-metaverse"
                                        aria-selected="false">{{ localize('Deposit') }}
                                    </button>
                                </li>
                                <li class="nav-item">
                                    <button type="button" class="nav-link" role="tab" data-bs-toggle="tab"
                                        data-bs-target="#navs-pills-top-gaming" aria-controls="navs-pills-top-gaming"
                                        aria-selected="false">{{ localize('Withdraw') }}
                                    </button>
                                </li>
                                <li class="nav-item">
                                    <button type="button" class="nav-link" role="tab" data-bs-toggle="tab"
                                        data-bs-target="#navs-pills-top-defi" aria-controls="navs-pills-top-defi"
                                        aria-selected="false">{{ localize('Transfer') }}
                                    </button>
                                </li>
                            </ul>
                        </div>

                        <div class="tab-content p-0">
                            <div class="tab-pane fade show active" id="navs-pills-top-all" role="tabpanel">
                                <div class="table-responsive market-table mb-3">
                                    <table class="table">
                                        <tbody class="table-border-top-0">
                                            @foreach ($allTransactionData as $key => $value)
                                                <tr>
                                                    <th>
                                                        <img
                                                            src="{{ $value->currencyInfo->logo ? assets('img/' . $value->currencyInfo->logo) : assets('img/blank50x50.png') }}">
                                                    </th>
                                                    <th class="text-black">{{ $value->customerInfo->user_id }}</th>
                                                    <th class="text-black">
                                                        @if ($value->txn_type->value === TxnTypeEnum::DEPOSIT->value)
                                                            <span
                                                                class="badge bg-label-success py-2">{{ TxnTypeEnum::DEPOSIT->name }}</span>
                                                        @elseif ($value->txn_type->value === TxnTypeEnum::WITHDRAW->value)
                                                            <span
                                                                class="badge bg-label-danger py-2">{{ TxnTypeEnum::WITHDRAW->name }}</span>
                                                        @else
                                                            <span
                                                                class="badge bg-label-warning py-2">{{ TxnTypeEnum::TRANSFER->name }}</span>
                                                        @endif
                                                    </th>
                                                    <th class="text-success text-end">
                                                        ${{ number_format($value->usd_value, 2) }}</th>
                                                    <th class="text-black">{{ get_ymd($value->created_at) }}</th>
                                                </tr>
                                            @endforeach
                                        </tbody>
                                    </table>
                                </div>
                                <div class="text-end">
                                    <a href="{{ route('deposit.index') }}"
                                        class="btn btn-outline-secondary fs-11 fw-semi-bold">{{ localize('View All') }}</a>
                                </div>
                            </div>
                            <div class="tab-pane fade" id="navs-pills-top-metaverse" role="tabpanel">
                                <div class="table-responsive market-table mb-3">
                                    <table class="table">
                                        <tbody class="table-border-top-0">
                                            @foreach ($deposits as $key => $value)
                                                <tr>
                                                    <th>
                                                        <img
                                                            src="{{ $value->currencyInfo->logo ? assets('img/' . $value->currencyInfo->logo) : assets('img/blank50x50.png') }}">
                                                    </th>
                                                    <th class="text-black">{{ $value->customerInfo->user_id }}</th>
                                                    <th class="text-black">
                                                        <span
                                                            class="badge bg-label-success py-2">{{ TxnTypeEnum::DEPOSIT->name }}</span>
                                                    </th>
                                                    <th class="text-success text-end">
                                                        ${{ number_format($value->usd_value, 2) }}</th>
                                                    <th class="text-black">{{ get_ymd($value->created_at) }}</th>
                                                </tr>
                                            @endforeach
                                        </tbody>
                                    </table>
                                </div>
                                <div class="text-end">
                                    <a href="{{ route('deposit.index') }}"
                                        class="btn btn-outline-secondary fs-11 fw-semi-bold">{{ localize('View All') }}</a>
                                </div>
                            </div>
                            <div class="tab-pane fade" id="navs-pills-top-gaming" role="tabpanel">
                                <div class="table-responsive market-table mb-3">
                                    <table class="table">
                                        <tbody class="table-border-top-0">
                                            @foreach ($withdraws as $key => $value)
                                                <tr>
                                                    <th>
                                                        <img
                                                            src="{{ $value->currencyInfo->logo ? assets('img/' . $value->currencyInfo->logo) : assets('img/blank50x50.png') }}">
                                                    </th>
                                                    <th class="text-black">{{ $value->customerInfo->user_id }}</th>
                                                    <th class="text-black">
                                                        <span
                                                            class="badge bg-label-danger py-2">{{ TxnTypeEnum::WITHDRAW->name }}</span>
                                                    </th>
                                                    <th class="text-success text-end">
                                                        ${{ number_format($value->usd_value, 2) }}</th>
                                                    <th class="text-black">{{ get_ymd($value->created_at) }}</th>
                                                </tr>
                                            @endforeach
                                        </tbody>
                                    </table>
                                </div>
                                <div class="text-end">
                                    <a href="{{ route('withdraw.index') }}"
                                        class="btn btn-outline-secondary fs-11 fw-semi-bold">{{ localize('View All') }}</a>
                                </div>
                            </div>
                            <div class="tab-pane fade" id="navs-pills-top-defi" role="tabpanel">
                                <div class="table-responsive market-table mb-3">
                                    <table class="table">
                                        <tbody class="table-border-top-0">
                                            @foreach ($transfers as $key => $value)
                                                <tr>
                                                    <th>
                                                        <img
                                                            src="{{ $value->currencyInfo->logo ? assets('img/' . $value->currencyInfo->logo) : assets('img/blank50x50.png') }}">
                                                    </th>
                                                    <th class="text-black">{{ $value->customerInfo->user_id }}</th>
                                                    <th class="text-black">
                                                        <span
                                                            class="badge bg-label-warning py-2">{{ TxnTypeEnum::TRANSFER->name }}</span>
                                                    </th>
                                                    <th class="text-success text-end">
                                                        ${{ number_format($value->usd_value, 2) }}</th>
                                                    <th class="text-black">{{ get_ymd($value->created_at) }}</th>
                                                </tr>
                                            @endforeach
                                        </tbody>
                                    </table>
                                </div>
                                <div class="text-end">
                                    <a href="{{ route('transfer.index') }}"
                                        class="btn btn-outline-secondary fs-11 fw-semi-bold">{{ localize('View All') }}</a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="row g-3">
            <div class="col-lg-3">
                <div class="card shadow-none radius-12">
                    <div class="card-body">
                        <div class="d-flex justify-content-between mb-3">
                            <div class="card-title m-0 me-2">
                                <h5 class="m-0 fs-20 text-black fw-semi-bold">{{ localize('Currency Deposits') }}</h5>
                            </div>
                        </div>
                        <div id="currencyDeposit"></div>
                    </div>
                </div>
            </div>
            <div class="col-lg-4">
                <div class="card shadow-none radius-12">
                    <div class="card-body">
                        <div class="d-flex justify-content-between mb-3">
                            <div class="card-title m-0">
                                <h5 class="m-0 fs-20 text-black fw-semi-bold">{{ localize('fees_history') }}</h5>
                            </div>
                            <a href="{{ route('fees-history') }}"
                                class="btn btn-outline-secondary fs-11 fw-semi-bold">{{ localize('view_all') }}</a>
                        </div>
                        <div class="table-responsive dashboard-history-table history-table mb-1">
                            <table class="table">
                                <tbody class="table-border-top-0">
                                    @foreach ($transactionFeeData as $key => $value)
                                        <tr>
                                            <th>
                                                <img
                                                    src="{{ $value->currencyInfo->logo ? assets('img/' . $value->currencyInfo->logo) : assets('img/blank50x50.png') }}">
                                            </th>
                                            <th class="text-black">{{ $value->customerInfo->user_id }}</th>
                                            <th class="text-black">
                                                @if ($value->txn_type->value === TxnTypeEnum::DEPOSIT->value)
                                                    <span
                                                        class="badge bg-label-success py-2">{{ TxnTypeEnum::DEPOSIT->name }}</span>
                                                @elseif ($value->txn_type->value === TxnTypeEnum::WITHDRAW->value)
                                                    <span
                                                        class="badge bg-label-danger py-2">{{ TxnTypeEnum::WITHDRAW->name }}</span>
                                                @else
                                                    <span
                                                        class="badge bg-label-warning py-2">{{ TxnTypeEnum::TRANSFER->name }}</span>
                                                @endif
                                            </th>
                                            <th class="text-success text-end">
                                                ${{ number_format($value->usd_value, 2) }}
                                            </th>
                                            <th class="text-black">{{ get_ymd($value->created_at) }}</th>
                                        </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-lg-5">
                <div class="card shadow-none radius-12">
                    <div class="card-body">
                        <div class="d-flex justify-content-between mb-3">
                            <div class="card-title m-0">
                                <h5 class="m-0 fs-20 text-black fw-semi-bold">{{ localize('Invest history') }}</h5>
                            </div>
                            <a href="{{ route('investment-history') }}"
                                class="btn btn-outline-secondary fs-11 fw-semi-bold">{{ localize('View All') }}</a>
                        </div>
                        <div class="table-responsive dashboard-history-table history-table mb-1">
                            <table class="table">
                                <tbody class="table-border-top-0">
                                    @foreach ($investmentHistoryData as $investData)
                                        <tr>
                                            <th>{{ $investData->user_id }}</th>
                                            <th class="text-success">{{ $investData->invest_qty }} qty X
                                                ${{ number_format($investData->invest_amount, 2, '.', '') }} =
                                                ${{ number_format($investData->total_invest_amount, 2, '.', '') }}
                                            </th>
                                            <th class="text-black">{{ $investData->created_at }}</th>
                                        </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>


        @push('lib-scripts')
            <!-- chart  -->
            <script src="{{ assets('vendor/apexcharts/dist/apexcharts.min.js') }}"></script>
        @endpush

        @push('js')
            <script src="{{ assets('js/pages/axios.min.js') }}"></script>
            <script src="{{ assets('js/pages/dashboard.js') }}"></script>
        @endpush
    @else
        <div class="alert alert-secondary" role="alert">
            {{ localize('Hi') }} {{ $_auth_user->first_name . ' ' . $_auth_user->last_name }},
            {{ localize('Welcome to our application') }}
        </div>
    @endif

</x-app-layout>
