<x-app-layout>
    <div class="row justify-content-center">
        <div class="col-lg-6">
            <div class="row gy-2">
                <div class="col-12">
                    <div class="card shadow-one">
                        <div class="card-body">
                            <div
                                class="d-flex flex-column flex-sm-row mt-0 text-center text-sm-start user-profile-header">
                                <div class="flex-shrink-0 mt-n2 mx-sm-0 mx-auto">
                                    @if (auth()->user()->image)
                                        <img src="{{ storage_asset(auth()->user()->image) }}" alt="user image"
                                            class="d-block h-auto rounded user-profile-img" />
                                    @else
                                        <img src="{{ assets('img/user.png') }}" alt="user image"
                                            class="d-block h-auto rounded user-profile-img" />
                                    @endif
                                </div>
                                <div class="flex-grow-1">
                                    <div
                                        class="d-flex align-items-md-end align-items-sm-start align-items-center justify-content-md-between justify-content-start mx-4 flex-md-row flex-column gap-4">
                                        <div class="user-profile-info">
                                            <h4 class="fs-20 fw-medium">
                                                {{ $user['first_name'] . ' ' . $user['last_name'] }}
                                            </h4>
                                            <ul
                                                class="d-flex flex-column flex-wrap gap-2 justify-content-sm-start list-inline mb-0">
                                                <li class="list-inline-item">
                                                    <svg width="17" height="17" viewBox="0 0 17 17"
                                                        fill="none" xmlns="http://www.w3.org/2000/svg">
                                                        <path fill-rule="evenodd" clip-rule="evenodd"
                                                            d="M4.25 0C4.71944 0 5.1 0.380558 5.1 0.85V1.7H11.9V0.85C11.9 0.380558 12.2806 0 12.75 0C13.2194 0 13.6 0.380558 13.6 0.85V1.70002C13.9902 1.70026 14.3304 1.70267 14.6158 1.72598C14.9518 1.75344 15.2861 1.81406 15.6077 1.97794C16.0874 2.22238 16.4776 2.61243 16.722 3.0923L16.7221 3.0924C16.8859 3.414 16.9466 3.74821 16.974 4.08422C17 4.4026 17 4.78915 17 5.23722V13.4628C17 13.9108 17 14.2974 16.974 14.6158C16.9466 14.9518 16.8859 15.286 16.7221 15.6076C16.4776 16.0875 16.0875 16.4776 15.6076 16.7221C15.286 16.8859 14.9518 16.9466 14.6158 16.974C14.2974 17 13.9108 17 13.4628 17H3.53722C3.08915 17 2.70261 17 2.38422 16.974C2.04821 16.9466 1.714 16.8859 1.39241 16.7221C0.91249 16.4776 0.522394 16.0875 0.277942 15.6077C0.114057 15.2861 0.0534408 14.9518 0.0259857 14.6158C-2.76747e-05 14.2974 -1.44454e-05 13.9108 7.29473e-07 13.4628V5.23724C-1.44454e-05 4.78916 -2.76747e-05 4.40261 0.0259859 4.08422C0.0534416 3.74819 0.114059 3.41396 0.277929 3.09234M1.7 6.8V13.43C1.7 13.9201 1.70066 14.2365 1.72034 14.4774C1.73921 14.7083 1.77124 14.7939 1.79264 14.8359C1.87414 14.9958 2.00419 15.1259 2.16403 15.2073L2.16413 15.2074C2.20615 15.2288 2.29175 15.2608 2.52266 15.2797C2.7635 15.2993 3.07993 15.3 3.57 15.3H13.43C13.9201 15.3 14.2365 15.2993 14.4773 15.2797C14.7083 15.2608 14.7939 15.2288 14.8359 15.2074L14.836 15.2073C14.9958 15.1259 15.1259 14.9958 15.2073 14.836L15.2074 14.8359C15.2288 14.7939 15.2608 14.7083 15.2797 14.4773C15.2993 14.2365 15.3 13.9201 15.3 13.43V6.8H1.7ZM15.2999 5.1H1.70006C1.70044 4.70466 1.70304 4.43443 1.72034 4.22266C1.73921 3.99175 1.77123 3.90614 1.79264 3.86412C1.87413 3.70419 2.00416 3.57414 2.16409 3.49265C2.20612 3.47124 2.29175 3.4392 2.52266 3.42034C2.7635 3.40066 3.07993 3.4 3.57 3.4H13.43C13.9201 3.4 14.2365 3.40066 14.4774 3.42034C14.7083 3.43921 14.7939 3.47123 14.8359 3.49264C14.9958 3.57414 15.1259 3.70418 15.2073 3.86403L15.2074 3.86413C15.2288 3.90615 15.2608 3.99175 15.2797 4.22266C15.297 4.43443 15.2996 4.70466 15.2999 5.1ZM3.4 9.34988C3.40007 8.88044 3.78068 8.49993 4.25012 8.5L12.7501 8.50119C13.2196 8.50126 13.6001 8.88187 13.6 9.35131C13.5999 9.82075 13.2193 10.2013 12.7499 10.2012L4.24988 10.2C3.78044 10.1999 3.39994 9.81932 3.4 9.34988ZM3.4 12.7499C3.40007 12.2804 3.78069 11.8999 4.25013 11.9L7.08343 11.9004C7.55287 11.9005 7.93338 12.2811 7.93331 12.7506C7.93324 13.22 7.55262 13.6005 7.08318 13.6004L4.24987 13.6C3.78043 13.5999 3.39993 13.2193 3.4 12.7499Z"
                                                            fill="#9B9B9B" />
                                                    </svg>
                                                    <span class="fs-16 fw-normal">{{ localize('Joined') }} :
                                                        {{ get_ymd($user['created_at']) }}</span>
                                                </li>
                                            </ul>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-12">
                    <div class="card shadow-one mb-3">
                        <div class="card-body">
                            <p class="mb-3 fs-16 fw-medium">{{ localize('About') }}</p>
                            <p class="mb-3 fs-14">{{ $user['about'] }}</p>
                            <p class="mb-3 fs-16 fw-medium">{{ localize('contact') }}</p>
                            <ul class="list-unstyled mb-4">
                                <li class="d-flex align-items-center mb-3">
                                    <svg width="19" height="15" viewBox="0 0 19 15" fill="none"
                                        xmlns="http://www.w3.org/2000/svg">
                                        <path
                                            d="M18 3.78571L14.637 5.62263C12.7621 6.64674 11.8247 7.15884 10.8319 7.3596C9.95314 7.53724 9.04686 7.53724 8.16814 7.3596C7.17538 7.15884 6.23792 6.64674 4.36298 5.62263L1 3.78571M4.02222 14H14.9778C16.0356 14 16.5646 14 16.9687 13.7976C17.3241 13.6196 17.6131 13.3354 17.7941 12.986C18 12.5888 18 12.0687 18 11.0286V3.97143C18 2.93134 18 2.41128 17.7941 2.01402C17.6131 1.66457 17.3241 1.38046 16.9687 1.20242C16.5646 1 16.0356 1 14.9778 1H4.02222C2.96435 1 2.4354 1 2.03135 1.20242C1.67593 1.38046 1.38697 1.66457 1.20588 2.01402C1 2.41128 1 2.93133 1 3.97143V11.0286C1 12.0687 1 12.5888 1.20588 12.986C1.38697 13.3354 1.67593 13.6196 2.03135 13.7976C2.4354 14 2.96434 14 4.02222 14Z"
                                            stroke="#A1A1A1" stroke-width="1.5" stroke-linecap="round"
                                            stroke-linejoin="round" />
                                    </svg>
                                    <span class="mx-2">{{ localize('email') }} :</span>
                                    <span>{{ $user['email'] }}</span>
                                </li>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

</x-app-layout>
