@php
    use App\Enums\CustomerVerifyStatusEnum;
@endphp
<div class="row gy-4">
    <div class="col-12">
        <div class="card py-4 pb-0 shadow-none radius-15">
            <div
                class="card-header align-items-center d-flex flex-column flex-lg-row gap-3 justify-content-between pt-0 px-4 px-xl-5">
                <ul class="nav nav-pills transaction-tab" id="pills-tab" role="tablist">
                    <li class="nav-item">
                        <a class="nav-link @if (!empty($activeMenu) && $activeMenu == 'profile') active @endif"
                            href="{{ route('customer.account.profile') }}">
                            <svg width="18" height="18" viewBox="0 0 27 21" fill="none"
                                xmlns="http://www.w3.org/2000/svg">
                                <path fill-rule="evenodd" clip-rule="evenodd"
                                    d="M6.11156 1.36837C6.99885 0.341223 8.25622 0 9.56413 0C10.872 0 12.1294 0.341219 13.0167 1.36837C13.8657 2.35116 14.156 3.71658 14.156 5.25C14.156 6.78344 13.8657 8.14886 13.0167 9.13165C12.1294 10.1588 10.872 10.5 9.56413 10.5C8.25624 10.5 6.99886 10.1588 6.11157 9.13166C5.26259 8.14887 4.97228 6.78345 4.97228 5.25C4.97228 3.71657 5.26259 2.35116 6.11156 1.36837ZM8.09685 3.08476C7.85253 3.36759 7.59619 3.97093 7.59619 5.25C7.59619 6.5291 7.85253 7.13243 8.09684 7.41526C8.30285 7.65373 8.68541 7.875 9.56413 7.875C10.4429 7.875 10.8254 7.65373 11.0314 7.41526C11.2757 7.13244 11.5321 6.52911 11.5321 5.25C11.5321 3.97092 11.2757 3.36758 11.0314 3.08475C10.8254 2.84628 10.4428 2.625 9.56413 2.625C8.68543 2.625 8.30286 2.84628 8.09685 3.08476ZM15.7286 0.238898C16.2692 0.0679506 16.8458 0 17.4359 0C18.7438 0 20.0012 0.341219 20.8884 1.36837C21.7374 2.35116 22.0277 3.71658 22.0277 5.25C22.0277 6.78344 21.7374 8.14886 20.8884 9.13165C20.0011 10.1588 18.7438 10.5 17.4359 10.5C16.8459 10.5 16.2693 10.4321 15.7286 10.2611C15.0377 10.0426 14.6547 9.30516 14.8731 8.61401C15.0915 7.92285 15.8287 7.5397 16.5195 7.75821C16.7423 7.82868 17.0403 7.875 17.4359 7.875C18.3146 7.875 18.6972 7.65373 18.9032 7.41526C19.1475 7.13244 19.4038 6.52911 19.4038 5.25C19.4038 3.97092 19.1475 3.36758 18.9031 3.08475C18.6971 2.84628 18.3146 2.625 17.4359 2.625C17.0404 2.625 16.7424 2.67134 16.5194 2.74184C15.8286 2.96031 15.0915 2.57711 14.8731 1.88594C14.6547 1.19477 15.0378 0.457364 15.7286 0.238898ZM4.62454 15.2946C3.596 15.8049 2.98397 16.5287 2.65302 17.517L1.40902 17.1L2.65302 17.517C2.59519 17.6897 2.6226 17.846 2.7817 18.018C2.96373 18.2149 3.28816 18.375 3.66032 18.375H15.4679C15.8401 18.375 16.1645 18.2149 16.3466 18.018C16.5057 17.846 16.5331 17.6897 16.4752 17.517C16.1443 16.5287 15.5322 15.8049 14.5037 15.2946C13.4236 14.7587 11.8353 14.4375 9.56413 14.4375C7.293 14.4375 5.70465 14.7587 4.62454 15.2946ZM3.4587 12.9429C5.0491 12.1538 7.09457 11.8125 9.56413 11.8125C12.0337 11.8125 14.0792 12.1538 15.6696 12.9429C17.3115 13.7576 18.4067 15.0213 18.9632 16.6831L18.9632 16.6831C19.3658 17.8851 18.9921 19.0225 18.2728 19.8005C17.5763 20.5537 16.5449 21 15.4679 21H3.66032C2.58334 21 1.55193 20.5537 0.855509 19.8005C0.136149 19.0226 -0.237513 17.8851 0.16502 16.6831L0.165024 16.6831C0.721555 15.0213 1.81673 13.7576 3.4587 12.9429ZM18.8305 13.1117C18.9341 12.3943 19.5995 11.8967 20.3166 12.0004C21.9671 12.2391 23.3727 12.7178 24.4905 13.5058C25.6287 14.3083 26.3999 15.384 26.835 16.683L26.835 16.6831C27.2375 17.8851 26.8639 19.0225 26.1445 19.8005C25.4481 20.5537 24.4167 21 23.3397 21H21.3784C20.6538 21 20.0665 20.4124 20.0665 19.6875C20.0665 18.9626 20.6538 18.375 21.3784 18.375H23.3397C23.7119 18.375 24.0363 18.2149 24.2183 18.018C24.3774 17.846 24.4048 17.6897 24.347 17.517C24.0805 16.7212 23.6378 16.116 22.979 15.6516C22.2998 15.1727 21.3252 14.7985 19.9412 14.5984C19.2241 14.4947 18.7268 13.8291 18.8305 13.1117Z"
                                    fill="#9B9B9B" />
                            </svg>
                            <span class="ms-1">{{ localize('Profile') }}</span>
                        </a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link @if (!empty($activeMenu) && $activeMenu == 'account') active @endif"
                            href="{{ route('customer.account.account.index') }}">
                            <svg width="18" height="18" viewBox="0 0 19 22" fill="none"
                                xmlns="http://www.w3.org/2000/svg">
                                <path
                                    d="M9.5 10C8.60999 10 7.73996 9.70675 6.99994 9.15735C6.25991 8.60794 5.68314 7.82705 5.34254 6.91342C5.00195 5.99979 4.91283 4.99445 5.08647 4.02455C5.2601 3.05465 5.68869 2.16373 6.31802 1.46447C6.94736 0.765206 7.74918 0.289002 8.6221 0.0960758C9.49501 -0.0968502 10.3998 0.00216642 11.2221 0.380605C12.0443 0.759043 12.7471 1.39991 13.2416 2.22215C13.7361 3.0444 14 4.0111 14 5C14 6.32608 13.5259 7.59785 12.682 8.53553C11.8381 9.47322 10.6935 10 9.5 10ZM9.5 2C8.96599 2 8.44397 2.17595 7.99996 2.50559C7.55595 2.83524 7.20988 3.30377 7.00553 3.85195C6.80117 4.40013 6.7477 5.00333 6.85188 5.58527C6.95606 6.16721 7.21321 6.70176 7.59081 7.12132C7.96841 7.54088 8.44951 7.8266 8.97326 7.94236C9.49701 8.05811 10.0399 7.9987 10.5332 7.77164C11.0266 7.54458 11.4483 7.16006 11.745 6.66671C12.0416 6.17336 12.2 5.59335 12.2 5C12.2 4.20435 11.9155 3.44129 11.4092 2.87868C10.9028 2.31607 10.2161 2 9.5 2Z"
                                    fill="#9B9B9B" />
                                <path
                                    d="M18.05 22H0.95C0.698044 22 0.456408 21.9034 0.278249 21.7315C0.100089 21.5596 0 21.3264 0 21.0833V18.3333C0 16.3884 0.800712 14.5231 2.22599 13.1479C3.65127 11.7726 5.58435 11 7.6 11H11.4C13.4156 11 15.3487 11.7726 16.774 13.1479C18.1993 14.5231 19 16.3884 19 18.3333V21.0833C19 21.3264 18.8999 21.5596 18.7218 21.7315C18.5436 21.9034 18.302 22 18.05 22ZM1.9 20.1667H17.1V18.3333C17.1 16.8746 16.4995 15.4757 15.4305 14.4442C14.3616 13.4128 12.9117 12.8333 11.4 12.8333H7.6C6.08827 12.8333 4.63845 13.4128 3.56949 14.4442C2.50053 15.4757 1.9 16.8746 1.9 18.3333V20.1667Z"
                                    fill="#9B9B9B" />
                            </svg>
                            <span class="ms-1">{{ localize('Account') }}</span>
                        </a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link @if (!empty($activeMenu) && $activeMenu == 'password-change') active @endif"
                            href="{{ route('customer.account.password-change.index') }}">
                            <svg width="18" height="18" viewBox="0 0 23 23" fill="none"
                                xmlns="http://www.w3.org/2000/svg">
                                <path
                                    d="M17.825 20.4444C17.529 21.9025 16.2399 23 14.6944 23H3.19444C1.4302 23 0 21.5698 0 19.8056V10.8611C0 9.31567 1.09746 8.02655 2.55556 7.73057V6.38889C2.55556 2.8604 5.41596 0 8.94444 0C12.4729 0 15.3333 2.8604 15.3333 6.38889V7.73057C16.7914 8.02655 17.8889 9.31567 17.8889 10.8611V12.7778H19.8056C21.5698 12.7778 23 14.208 23 15.9722V17.25C23 19.0142 21.5698 20.4444 19.8056 20.4444H17.825ZM16.502 20.4444H10.8611C9.09687 20.4444 7.66667 19.0142 7.66667 17.25V15.9722C7.66667 14.208 9.09687 12.7778 10.8611 12.7778H16.6111V10.8611C16.6111 9.85229 15.8317 9.0255 14.8422 8.95006C14.7948 8.96129 14.7453 8.96723 14.6944 8.96723C14.6357 8.96723 14.5788 8.9593 14.5247 8.94444H3.19444C2.1359 8.94444 1.27778 9.80257 1.27778 10.8611V19.8056C1.27778 20.8641 2.1359 21.7222 3.19444 21.7222H14.6944C15.529 21.7222 16.2389 21.1889 16.502 20.4444ZM3.83333 7.66667H14.0556V6.38889C14.0556 3.5661 11.7672 1.27778 8.94444 1.27778C6.12166 1.27778 3.83333 3.5661 3.83333 6.38889V7.66667ZM21.7222 17.25V15.9722C21.7222 14.9137 20.8641 14.0556 19.8056 14.0556H10.8611C9.80257 14.0556 8.94444 14.9137 8.94444 15.9722V17.25C8.94444 18.3085 9.80257 19.1667 10.8611 19.1667H19.8056C20.8641 19.1667 21.7222 18.3085 21.7222 17.25ZM10.8611 15.3333H12.1389C12.4917 15.3333 12.7778 15.6194 12.7778 15.9722V17.25C12.7778 17.6028 12.4917 17.8889 12.1389 17.8889H10.8611C10.5083 17.8889 10.2222 17.6028 10.2222 17.25V15.9722C10.2222 15.6194 10.5083 15.3333 10.8611 15.3333ZM14.6944 15.3333H15.9722C16.3251 15.3333 16.6111 15.6194 16.6111 15.9722V17.25C16.6111 17.6028 16.3251 17.8889 15.9722 17.8889H14.6944C14.3416 17.8889 14.0556 17.6028 14.0556 17.25V15.9722C14.0556 15.6194 14.3416 15.3333 14.6944 15.3333ZM18.5278 15.3333H19.8056C20.1584 15.3333 20.4444 15.6194 20.4444 15.9722V17.25C20.4444 17.6028 20.1584 17.8889 19.8056 17.8889H18.5278C18.1749 17.8889 17.8889 17.6028 17.8889 17.25V15.9722C17.8889 15.6194 18.1749 15.3333 18.5278 15.3333Z"
                                    fill="#9B9B9B" />
                            </svg>
                            <span class="ms-1">{{ localize('Password Change') }}</span>
                        </a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link @if (!empty($activeMenu) && $activeMenu == 'two-factor') active @endif"
                            href="{{ route('customer.account.two-factor.index') }}">
                            <svg width="18" height="18" viewBox="0 0 18 17" fill="none"
                                xmlns="http://www.w3.org/2000/svg">
                                <path
                                    d="M6.99528 9.84534C6.36052 9.17469 5.47582 8.75862 4.49725 8.75862C2.56577 8.75862 1 10.3797 1 12.3793C1 14.379 2.56577 16 4.49725 16C6.42872 16 7.99449 14.379 7.99449 12.3793C7.99449 11.3927 7.61339 10.4984 6.99528 9.84534ZM6.99528 9.84534L12.0229 4.64028M12.0229 4.64028L13.0284 3.59927L14.2585 2.29963M12.0229 4.64028L14.0024 6.68965M15.4886 1L14.2585 2.29963M14.2585 2.29963L17 5.13793"
                                    stroke="#9B9B9B" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" />
                            </svg>
                            <span class="ms-1">{{ localize('Two Factor') }}</span>
                        </a>
                    </li>
                    @if ($customer->verified_status->value == CustomerVerifyStatusEnum::NOT_SUBMIT->value || $customer->verified_status->value == CustomerVerifyStatusEnum::CANCELED->value)
                    <li class="nav-item">
                        <a class="nav-link @if (!empty($activeMenu) && $activeMenu == 'kyc-verification') active @endif"
                            href="{{ route('customer.account.kyc-verification.index') }}">
                            <svg width="18" height="18" viewBox="0 0 27 21" fill="none"
                                xmlns="http://www.w3.org/2000/svg">
                                <path fill-rule="evenodd" clip-rule="evenodd"
                                    d="M6.11156 1.36837C6.99885 0.341223 8.25622 0 9.56413 0C10.872 0 12.1294 0.341219 13.0167 1.36837C13.8657 2.35116 14.156 3.71658 14.156 5.25C14.156 6.78344 13.8657 8.14886 13.0167 9.13165C12.1294 10.1588 10.872 10.5 9.56413 10.5C8.25624 10.5 6.99886 10.1588 6.11157 9.13166C5.26259 8.14887 4.97228 6.78345 4.97228 5.25C4.97228 3.71657 5.26259 2.35116 6.11156 1.36837ZM8.09685 3.08476C7.85253 3.36759 7.59619 3.97093 7.59619 5.25C7.59619 6.5291 7.85253 7.13243 8.09684 7.41526C8.30285 7.65373 8.68541 7.875 9.56413 7.875C10.4429 7.875 10.8254 7.65373 11.0314 7.41526C11.2757 7.13244 11.5321 6.52911 11.5321 5.25C11.5321 3.97092 11.2757 3.36758 11.0314 3.08475C10.8254 2.84628 10.4428 2.625 9.56413 2.625C8.68543 2.625 8.30286 2.84628 8.09685 3.08476ZM15.7286 0.238898C16.2692 0.0679506 16.8458 0 17.4359 0C18.7438 0 20.0012 0.341219 20.8884 1.36837C21.7374 2.35116 22.0277 3.71658 22.0277 5.25C22.0277 6.78344 21.7374 8.14886 20.8884 9.13165C20.0011 10.1588 18.7438 10.5 17.4359 10.5C16.8459 10.5 16.2693 10.4321 15.7286 10.2611C15.0377 10.0426 14.6547 9.30516 14.8731 8.61401C15.0915 7.92285 15.8287 7.5397 16.5195 7.75821C16.7423 7.82868 17.0403 7.875 17.4359 7.875C18.3146 7.875 18.6972 7.65373 18.9032 7.41526C19.1475 7.13244 19.4038 6.52911 19.4038 5.25C19.4038 3.97092 19.1475 3.36758 18.9031 3.08475C18.6971 2.84628 18.3146 2.625 17.4359 2.625C17.0404 2.625 16.7424 2.67134 16.5194 2.74184C15.8286 2.96031 15.0915 2.57711 14.8731 1.88594C14.6547 1.19477 15.0378 0.457364 15.7286 0.238898ZM4.62454 15.2946C3.596 15.8049 2.98397 16.5287 2.65302 17.517L1.40902 17.1L2.65302 17.517C2.59519 17.6897 2.6226 17.846 2.7817 18.018C2.96373 18.2149 3.28816 18.375 3.66032 18.375H15.4679C15.8401 18.375 16.1645 18.2149 16.3466 18.018C16.5057 17.846 16.5331 17.6897 16.4752 17.517C16.1443 16.5287 15.5322 15.8049 14.5037 15.2946C13.4236 14.7587 11.8353 14.4375 9.56413 14.4375C7.293 14.4375 5.70465 14.7587 4.62454 15.2946ZM3.4587 12.9429C5.0491 12.1538 7.09457 11.8125 9.56413 11.8125C12.0337 11.8125 14.0792 12.1538 15.6696 12.9429C17.3115 13.7576 18.4067 15.0213 18.9632 16.6831L18.9632 16.6831C19.3658 17.8851 18.9921 19.0225 18.2728 19.8005C17.5763 20.5537 16.5449 21 15.4679 21H3.66032C2.58334 21 1.55193 20.5537 0.855509 19.8005C0.136149 19.0226 -0.237513 17.8851 0.16502 16.6831L0.165024 16.6831C0.721555 15.0213 1.81673 13.7576 3.4587 12.9429ZM18.8305 13.1117C18.9341 12.3943 19.5995 11.8967 20.3166 12.0004C21.9671 12.2391 23.3727 12.7178 24.4905 13.5058C25.6287 14.3083 26.3999 15.384 26.835 16.683L26.835 16.6831C27.2375 17.8851 26.8639 19.0225 26.1445 19.8005C25.4481 20.5537 24.4167 21 23.3397 21H21.3784C20.6538 21 20.0665 20.4124 20.0665 19.6875C20.0665 18.9626 20.6538 18.375 21.3784 18.375H23.3397C23.7119 18.375 24.0363 18.2149 24.2183 18.018C24.3774 17.846 24.4048 17.6897 24.347 17.517C24.0805 16.7212 23.6378 16.116 22.979 15.6516C22.2998 15.1727 21.3252 14.7985 19.9412 14.5984C19.2241 14.4947 18.7268 13.8291 18.8305 13.1117Z"
                                    fill="#9B9B9B" />
                            </svg>
                            <span class="ms-1">{{ localize('KYC Verification') }}</span>
                        </a>
                    </li>
                    @endif
                </ul>
            </div>

            <div class="card-body">
                @if ($customer->verified_status !== CustomerVerifyStatusEnum::PROCESSING)
                    @if (isset($activeMenuTitle))
                        <h5 class="mb-4 pb-4 border-bottom fs-20 fw-semi-bold">{{ $activeMenuTitle }}</h5>
                    @endif
                @endif


                {{ $slot }}
            </div>
        </div>
    </div>
</div>
