@php
    use Carbon\Carbon;
@endphp
<x-customer-app-layout>
    <x-customer.account activeMenu="two-factor" activeMenuTitle="{{ localize('Two Factor') }}" :customer="$customer">
        <div class="row justify-content-center">

            <div class="col-lg-7">
                <h3 class="mb-3 fs-30 fw-semi-bold">{{ localize('Authenticator Apps') }}</h3>
                <p class="text-black-50 mb-3 fs-16 fw-normal">{{ localize('Install Google Authentication') }}
                    <a class="text-primary fw-medium" target="_blank"
                        href="https://play.google.com/store/apps/details?id=com.google.android.apps.authenticator2">
                        ({{ localize('Install here') }})
                    </a>
                    {{ localize('Or') }}
                    <a class="text-primary fw-medium" target="_blank"
                        href="https://chrome.google.com/webstore/detail/authenticator/bhghoamapcdpbohphigoooaddinpkbai?hl=en-US">
                        {{ localize('Authenticator Apps') }}Chrome Extension
                    </a> {{ localize('OR') }}
                    <a class="text-primary fw-medium" target="_blank"
                        href="https://addons.mozilla.org/en-US/firefox/addon/auth-helper/">
                        Firefox Add-ons
                    </a> {{ localize('OR') }}
                    <a class="text-primary fw-medium" target="_blank"
                        href="https://www.microsoft.com/en-bd/p/authenticator-extension/9p0fd39wffmk?ocid=badge&amp;rtc=1#activetab=pivot:overviewtab">
                        Microsoft (Edge)
                    </a>
                </p>


                <div id="authentication_section">

                    @if (isset($secretKey) && isset($qrImage))
                        <div class="mb-3 text-center">
                            {!! $qrImage !!}
                        </div>
                        <div class="badge bg-label-primary py-3 px-3 px-md-5 mb-4">
                            <div class="d-flex align-items-center gap-3">
                                <svg width="25" height="25" viewBox="0 0 25 25" fill="none"
                                    xmlns="http://www.w3.org/2000/svg">
                                    <path
                                        d="M12.5 25C5.59625 25 0 19.4037 0 12.5C0 5.59625 5.59625 0 12.5 0C19.4037 0 25 5.59625 25 12.5C25 19.4037 19.4037 25 12.5 25ZM11.63 20.5825C12.4175 20.5825 13.295 20.2225 14.375 18.76L15.5138 17.235C15.547 17.1904 15.5711 17.1396 15.5845 17.0856C15.5979 17.0316 15.6003 16.9755 15.5917 16.9205C15.5831 16.8656 15.5636 16.8129 15.5343 16.7656C15.505 16.7182 15.4666 16.6773 15.4212 16.645C15.3254 16.5773 15.2078 16.5475 15.0912 16.5613C14.9747 16.5752 14.8674 16.6317 14.79 16.72L12.9463 18.8188C12.9038 18.867 12.8471 18.9004 12.7844 18.9141C12.7216 18.9278 12.6562 18.9211 12.5975 18.895C12.5406 18.87 12.4943 18.8257 12.4668 18.7699C12.4394 18.7141 12.4325 18.6504 12.4475 18.59L14.77 9.2825C14.7957 9.18106 14.7954 9.07479 14.7692 8.97348C14.7431 8.87217 14.6918 8.77907 14.6202 8.70275C14.5487 8.62643 14.459 8.56935 14.3596 8.53676C14.2602 8.50417 14.1541 8.49712 14.0513 8.51625L9.86375 9.2825C9.78142 9.29762 9.70515 9.33604 9.644 9.3932C9.58285 9.45036 9.53938 9.52387 9.51875 9.605L9.41125 10.0225C9.39941 10.0687 9.39832 10.1171 9.40806 10.1638C9.41781 10.2105 9.43812 10.2544 9.46744 10.292C9.49677 10.3297 9.53433 10.3601 9.57724 10.381C9.62015 10.4019 9.66728 10.4127 9.715 10.4125H11.8775L10.0325 17.815C9.965 18.1075 9.8525 18.6025 9.8525 18.9625C9.8525 19.795 10.3475 20.5825 11.63 20.5825ZM13.9175 7.4125C14.795 7.4125 15.47 6.895 15.65 6.1075C15.695 5.9275 15.7175 5.725 15.7175 5.59C15.7175 4.96 15.2225 4.375 14.3 4.375C13.4225 4.375 12.7475 4.8925 12.5675 5.68C12.5257 5.84944 12.5031 6.02302 12.5 6.1975C12.5 6.8275 12.995 7.4125 13.9175 7.4125Z"
                                        fill="#0060FF" />
                                </svg>
                                <div class="text-start">
                                    <p class="text-primary mb-2 fs-16 fw-normal w-s">
                                        {{ localize('If You Having trouble using the QR Code , Select manual entry on your app, and enter your username and the code') }}
                                    </p>
                                    <p class="text-black mb-0 fs-18 fw-medium">{{ $secretKey }}</p>
                                </div>
                            </div>
                        </div>
                    @else
                        <div class="alert alert-danger alert-dismissible d-flex align-items-baseline" role="alert">
                            <svg width="25" height="25" viewBox="0 0 25 25" fill="none"
                                xmlns="http://www.w3.org/2000/svg">
                                <path
                                    d="M12.5 25C5.59625 25 0 19.4037 0 12.5C0 5.59625 5.59625 0 12.5 0C19.4037 0 25 5.59625 25 12.5C25 19.4037 19.4037 25 12.5 25ZM11.63 20.5825C12.4175 20.5825 13.295 20.2225 14.375 18.76L15.5138 17.235C15.547 17.1904 15.5711 17.1396 15.5845 17.0856C15.5979 17.0316 15.6003 16.9755 15.5917 16.9205C15.5831 16.8656 15.5636 16.8129 15.5343 16.7656C15.505 16.7182 15.4666 16.6773 15.4212 16.645C15.3254 16.5773 15.2078 16.5475 15.0912 16.5613C14.9747 16.5752 14.8674 16.6317 14.79 16.72L12.9463 18.8188C12.9038 18.867 12.8471 18.9004 12.7844 18.9141C12.7216 18.9278 12.6562 18.9211 12.5975 18.895C12.5406 18.87 12.4943 18.8257 12.4668 18.7699C12.4394 18.7141 12.4325 18.6504 12.4475 18.59L14.77 9.2825C14.7957 9.18106 14.7954 9.07479 14.7692 8.97348C14.7431 8.87217 14.6918 8.77907 14.6202 8.70275C14.5487 8.62643 14.459 8.56935 14.3596 8.53676C14.2602 8.50417 14.1541 8.49712 14.0513 8.51625L9.86375 9.2825C9.78142 9.29762 9.70515 9.33604 9.644 9.3932C9.58285 9.45036 9.53938 9.52387 9.51875 9.605L9.41125 10.0225C9.39941 10.0687 9.39832 10.1171 9.40806 10.1638C9.41781 10.2105 9.43812 10.2544 9.46744 10.292C9.49677 10.3297 9.53433 10.3601 9.57724 10.381C9.62015 10.4019 9.66728 10.4127 9.715 10.4125H11.8775L10.0325 17.815C9.965 18.1075 9.8525 18.6025 9.8525 18.9625C9.8525 19.795 10.3475 20.5825 11.63 20.5825ZM13.9175 7.4125C14.795 7.4125 15.47 6.895 15.65 6.1075C15.695 5.9275 15.7175 5.725 15.7175 5.59C15.7175 4.96 15.2225 4.375 14.3 4.375C13.4225 4.375 12.7475 4.8925 12.5675 5.68C12.5257 5.84944 12.5031 6.02302 12.5 6.1975C12.5 6.8275 12.995 7.4125 13.9175 7.4125Z"
                                    fill="#0060FF" />
                            </svg>
                            <div class="d-flex flex-column ps-1">
                                <h5 class="alert-heading mb-2">{{ localize('Read Carefully') }}</h5>
                                <p class="mb-0">
                                    {{ localize('Your google 2fa authentication is now enabled, if you want to remove authentication,  please enter the verification code and click the save changes button.') }}
                                </p>
                            </div>
                        </div>
                    @endif
                </div>

                {{-- Two Factor Verification Form --}}
                <form action="{{ route('customer.account.two-factor.update') }}" method="post" class=""
                    data="showCallBackData" id="two-factor-form" novalidate="" enctype="multipart/form-data">
                    @csrf
                    @method('patch')

                    <div class="mb-3">
                        <label class="col-form-label text-start text-color-1 fs-16 fw-medium"
                            for="verification_code">{{ localize('Verification Code') }} <span
                                class="text-danger">*</span>
                        </label>
                        <input type="text" name="verification_code" id="verification_code"
                            class="custom-form-control  form-control @error('verification_code') is-invalid @enderror"
                            placeholder="{{ localize('enter code') }}" required />
                        <div class="invalid-feedback" role="alert">
                            @error('verification_code')
                                {{ $message }}
                            @enderror
                        </div>
                    </div>
                    <div class="d-flex gap-3">
                        <button type="reset" class="btn btn-reset w-auto resetBtn">
                            <i class="fa fa-undo-alt"></i>
                        </button>
                        <button class="btn btn-save ms-3 w-auto actionBtn"
                            type="submit">{{ localize('Save') }}</button>
                    </div>
                </form>
                {{-- Two Factor Verification Form --}}

            </div>
        </div>
    </x-customer.account>
    @push('js')
        <script src="{{ assets('customer/js/two_factor.min.js') }}"></script>
    @endpush
</x-customer-app-layout>
